% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mlpsa.ctree}
\alias{mlpsa.ctree}
\title{Estimates propensity scores using the recursive partitioning in a conditional inference framework.}
\usage{
mlpsa.ctree(vars, formula, level2, ...)
}
\arguments{
\item{vars}{a data frame containing the covariates to use for estimating the propensity scores.}

\item{formula}{the model for estimating the propensity scores. For example,
treat ~ .}

\item{level2}{the name of the column in \code{vars} specifying the level 2 (or cluster).}

\item{...}{currently unused.}
}
\value{
a list of BinaryTree-class classes for each level 2
}
\description{
This function will estimate propensity scores using the conditional inference
framework as outlined in the \code{party} package. Specifically, a separate
tree will be estimated for each level 2 (or cluster). A key advantage of this
framework over other methods for estimating propensity scores is that this
method will work on data sets containing missing values.
}
\references{
Torsten Hothorn, Kurt Hornik and Achim Zeileis (2006). Unbiased
            Recursive Partitioning: A Conditional Inference Framework. Journal
            of Computational and Graphical Statistics, 15(3), 651--674.
}
\seealso{
\code{\link{getStrata}}

\code{\link{tree.plot}}
}

