% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multibiasmeta-package.R
\docType{package}
\name{multibiasmeta-package}
\alias{multibiasmeta}
\alias{multibiasmeta-package}
\title{multibiasmeta: Sensitivity Analysis for Multiple Biases in Meta-Analyses}
\description{
Meta-analyses can be compromised by studies' internal biases (e.g., confounding in nonrandomized studies) as well as by publication bias. This package conducts sensitivity analyses for the joint effects of these biases (per Mathur (2022) \doi{10.31219/osf.io/u7vcb}). These sensitivity analyses address two questions: (1) For a given severity of internal bias across studies and of publication bias, how much could the results change?; and (2) For a given severity of publication bias, how severe would internal bias have to be, hypothetically, to attenuate the results to the null or by a given amount?
}
\references{
\insertRef{mathur2022multibias}{multibiasmeta}

\insertRef{ding2016}{metabias}

\insertRef{smith2019}{metabias}

\insertRef{vanderweele2019}{metabias}

\insertRef{mathur2021}{metabias}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mathurlabstanford/multibiasmeta}
  \item \url{https://mathurlabstanford.github.io/multibiasmeta/}
  \item Report bugs at \url{https://github.com/mathurlabstanford/multibiasmeta/issues}
}

}
\author{
\strong{Maintainer}: Mika Braginsky \email{mika.br@gmail.com}

Authors:
\itemize{
  \item Maya Mathur \email{mmathur@stanford.edu}
}

}
\keyword{internal}
