% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_emc_omc.R
\name{adjust_emc_omc}
\alias{adjust_emc_omc}
\title{Adust for exposure misclassification and outcome misclassification.}
\usage{
adjust_emc_omc(
  data,
  exposure,
  outcome,
  confounders = NULL,
  x_model_coefs,
  y_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders are allowed.}

\item{x_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(X=1)) = &delta;<sub>0</sub> + &delta;<sub>1</sub>X* + &delta;<sub>2</sub>Y* + &delta;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(X=1)) = \delta_0 + \delta_1 X^* + \delta_2 Y^* + \delta{2+j} C_j, }}
where X represents the binary true exposure, X* is the binary misclassified
exposure, Y* is the binary misclassified outcome,
C represents the vector of binary
measured confounders (if any), and j corresponds to the number of measured
confounders. The number of parameters is therefore 3 + j.}

\item{y_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(Y=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y* + &beta;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(Y=1)) = |beta_0 + \beta_1 X + \beta_2 Y^* + \beta{{2+j}} C_j, }}
where Y represents the binary true exposure,
X is the binary exposure, Y is the binary misclassified outcome,
C represents the vector of binary measured confounders
(if any), and j corresponds to the number of measured confounders.
The number of parameters is therefore 3 + j.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
 effect of the exposure on the outcome and the second item is the
 confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_emc_omc} returns the exposure-outcome odds ratio and confidence
interval, adjusted for exposure misclassification and outcome
misclassification.
}
\details{
Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_emc_omc(
  df_emc_omc,
  exposure = "Xstar",
  outcome = "Ystar",
  confounders = "C1",
  x_model_coefs = c(-2.15, 1.64, 0.35, 0.38),
  y_model_coefs = c(-3.10, 0.63, 1.60, 0.39)
)

}
