% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domainChecks.R
\name{checkRn}
\alias{checkRn}
\title{Domain check for \eqn{R^n }}
\usage{
checkRn(x)
}
\arguments{
\item{x}{Matrix with numeric entries. Each row represents one point}
}
\value{
Vector where each element (TRUE or FALSE) indicates if a point is in R^n
}
\description{
The function checks if a point (one row in the input argument) is inside the n-dimensional Euclidean space \eqn{R^n = \times_{i=1}^n R} or not.
In this case the return values are all TRUE.
If the input matrix contains entries that are not numeric, i.e., not representing real numbers, the function throws an error.
The dimension \eqn{n} is automatically inferred from the input matrix and is equal to the number of columns.
}
\examples{
x <- matrix(rnorm(30),10,3)
checkRn(x)
}
\author{
Klaus Herrmann
}
