% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{calc_mv_dist}
\alias{calc_mv_dist}
\title{Compute Mahalanobis distances between all pairs of observations}
\usage{
calc_mv_dist(x)
}
\arguments{
\item{x}{multivariate data set}
}
\value{
vector of length n
}
\description{
For a data matrix, compute the sample variance-covariance,
which is used to compute the Mahalanobis distance.
}
\details{
This is useful for checking distance arise from a
multivariate normal sample.
}
\examples{
require(ggplot2)
require(tibble)
data(aflw)
aflw_std <- apply(aflw[,7:35], 2, function(x)
                    (x-mean(x, na.rm=TRUE))/
							       sd(x, na.rm=TRUE))
d <- calc_mv_dist(aflw_std[,c("goals","behinds",
                               "kicks","disposals")])
d <- as_tibble(d, .name_repair="minimal")
ggplot(d, aes(x=value)) + geom_histogram()
}
