% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata_subset.R
\name{rbind.mudata}
\alias{rbind.mudata}
\title{Combine mudata objects}
\usage{
\method{rbind}{mudata}(..., validate = TRUE)
}
\arguments{
\item{...}{\link{mudata} objects to combine}

\item{validate}{Flag to validate the final object using \link{validate_mudata}.}
}
\value{
A mudata object
}
\description{
This implmentation of \link{rbind} combines component tables using \link[dplyr:bind]{bind_rows}
and \link[dplyr:distinct]{distinct}. When combined object use different datasets, or when subsets of
the same object are recombined, this function works well. When this is not the case, it
may be necessary to modify the tables such that when they are passed to \link[dplyr:bind]{bind_rows}
and \link[dplyr:distinct]{distinct}, no duplicate information exists. This should be picked up by
\link{validate_mudata}.
}
\examples{
rbind(
  kentvillegreenwood \%>\%
    select_params(maxtemp) \%>\%
    select_locations(starts_with("KENT")),
  kentvillegreenwood \%>\%
    select_params(mintemp) \%>\%
    select_locations(starts_with("GREEN"))
)

}
