% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata-io.R
\name{mudata_prepare_column}
\alias{mudata_prepare_column}
\alias{mudata_prepare_tbl}
\alias{mudata_prepare_tbl.default}
\alias{mudata_prepare_tbl.tbl}
\alias{mudata_prepare_tbl.data.frame}
\alias{mudata_prepare_column.default}
\alias{mudata_prepare_column.POSIXt}
\alias{mudata_prepare_column.sfc}
\alias{mudata_prepare_column.hms}
\alias{mudata_prepare_column.list}
\alias{mudata_parse_column}
\alias{mudata_parse_tbl}
\title{Prepare mudata table columns for writing}
\usage{
mudata_prepare_column(x, format = NA, ...)

mudata_prepare_tbl(x, format = NA, ...)

\method{mudata_prepare_tbl}{default}(x, format = NA, ...)

\method{mudata_prepare_tbl}{tbl}(x, format = NA, ...)

\method{mudata_prepare_tbl}{data.frame}(x, format = NA, ...)

\method{mudata_prepare_column}{default}(x, format = NA, ...)

\method{mudata_prepare_column}{POSIXt}(x, format = NA, ...)

\method{mudata_prepare_column}{sfc}(x, format = NA, ...)

\method{mudata_prepare_column}{hms}(x, format = NA, ...)

\method{mudata_prepare_column}{list}(x, format = NA, ...)

mudata_parse_column(x, type_str = NA_character_, ...)

mudata_parse_tbl(x, type_str = NA_character_, ...)
}
\arguments{
\item{x}{A an object}

\item{format}{csv, json, or NA for unknown,}

\item{...}{Passed to methods}

\item{type_str}{A type string, generated by the internal \code{generate_type_str}}
}
\value{
An atomic vector
}
\description{
This set of generics is similar to \link[readr:output_column]{output_column} in that it
converts columns to a form suitable to writing.
\code{mudata_prepare_column} in combination with is
intended to be opposites with \code{mudata_parse_column} except for
date/time vectors that are not in UTC (mudata_parse_column assumes UTC,
and mudata_prepare_column always converts to UTC with a message).
}
\details{
Type strings are currently internal, and are in the columns table in the
"type" column. They are usually one of "character", "date", "datetime", "double",
"integer", "json", and "wkt". They can also contain simple arguments, like
"wkt(epsg=4326)" (actually, "wkt" is the only type string that should have arguments).
You should generally not mess with these (in fact, the "type" column in the coluns
table is overwritten right before read by default, so it is hard to mess this up).
}
