% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diabetes.R
\docType{data}
\name{diabetes}
\alias{diabetes}
\title{Network meta-analysis studying the incidence of diabetes}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{study}}\tab study label \cr
\bold{\emph{id}}\tab study id \cr
\bold{\emph{t}}\tab treatment label \cr
\bold{\emph{r}}\tab number of events \cr
\bold{\emph{n}}\tab group sample size \cr
\bold{\emph{rob}}\tab risk of bias assessment
}
}
\source{
Elliott W, Meyer P (2007):
Incident diabetes in clinical trials of antihypertensive drugs:
a network meta-analysis
\emph{Lancet},
\bold{369}
}
\description{
Network meta-analysis comparing six antihypertensive drugs against the
incidence of diabetes.
}
\examples{
data(diabetes)
#
ranks <- tcc(treat = t, studlab = study, event = r, n = n, data = diabetes,
  mcid = 1.20, sm = "OR", small.values = "desirable")
#
forest(ranks, treat = "ARB")
}
\seealso{
\code{\link{mtrank}}, \code{\link{tcc}}
}
\keyword{datasets}
