% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microstrategy.R
\docType{methods}
\name{update_dataset}
\alias{update_dataset}
\alias{update_dataset,connection-method}
\title{Update a previously created dataset (deprecated)}
\usage{
update_dataset(connection, data_frame, dataset_id, table_id, table_name,
  update_policy)

\S4method{update_dataset}{connection}(connection, data_frame, dataset_id,
  table_name, update_policy)
}
\arguments{
\item{connection}{MicroStrategy REST API connection object}

\item{data_frame}{R Data.Frame to use to update an in-memory dataset}

\item{dataset_id}{Identifier of the dataset to update, provided by \code{create_dataset()}}

\item{table_id}{Not used. Identifier of the table to update within the dataset, provided by \code{create_dataset()}}

\item{table_name}{Name of the table to update within the dataset}

\item{update_policy}{Update operation to perform. One of 'add' (inserts new, unique rows), 'update'
(updates data in existing rows and columns), 'upsert' (updates existing
data and inserts new rows), 'replace' (similar to truncate and load, replaces the existing data with new data)}
}
\description{
Updates a previously created MicroStrategy dataset with an R Data.Frame. This function is deprecated.
 Check out the add_table() & update() & publish() method from the Dataset class, which allows for updating multi-table datasets.
 \code{\link{Dataset}}
}
\examples{
\donttest{
df <- iris

# Create a primary key
df$ID <- as.character(row.names(df))

# Remove periods and other special characters due to their
# special role in MicroStrategy. But, "_" is ok.
names(df) <- c("Sepal_Length", "Sepal_Width", "Petal_Length", "Petal_Width", "Species", "ID")

# Create the dataset
mydf <- create_dataset(connection = conn,
                       data_frame = df,
                       dataset_name = "IRIS",
                       table_name = "IRIS")

# Add new rows to the dataset with update policy "add"
df2 <- df[sample(nrow(df), 5), ]
df2[, 'ID'] <- as.character(nrow(df) + seq(1:5))
update_dataset(connection = conn, data_frame = df2,
               dataset_id = mydf$datasetID,
               table_id = mydf$tableID,
               table_name = mydf$name,
               update_policy = 'add')

# Update existing data in the dataset with update policy "update"
df$Sepal_Length <- df$Sepal_Length + runif(nrow(df))
df$Petal_Width <- df$Sepal_Length + rnorm(nrow(df))
update_dataset(connection = conn, data_frame = df,
               dataset_id = mydf$datasetID,
               table_id = mydf$tableID,
               table_name = mydf$name,
               update_policy = 'update')

# Update and add new rows to the dataset with update policy "upsert"
df$Sepal_Length <- df$Sepal_Length + runif(nrow(df))
df$Petal_Width <- df$Sepal_Length + rnorm(nrow(df))
df2 <- df[sample(nrow(df), 5), ]
df2[, 'ID'] <- as.character(nrow(df) + seq(1:5))
df <- rbind(df, df2)
update_dataset(connection = conn,
               data_frame = df,
               dataset_id = mydf$datasetID,
               table_id = mydf$tableID,
               table_name = mydf$name,
               update_policy = 'upsert')

# Truncate and load new data into the dataset with update policy "replace"
df[] <- lapply(df, sample)
update_dataset(connection = conn, data_frame = df,
               dataset_id = mydf$datasetID,
               table_id = mydf$tableID,
               table_name = mydf$name,
               update_policy = 'replace')

# It is possible to update a dataset if it wasn't created in this session or by another client.
# Simply provide the dataset ID and table IDs to this function as characters.
df[] <- lapply(df, sample)  # shuffle contents of the dataframe
update_dataset(connection = conn, data_frame = df,
               dataset_id = "5E2501A411E8756818A50080EF4524C9",
               table_id = "F0DA816816432E448F1105327C119596",
               table_name = "IRIS",
               update_policy = 'replace')
}
}
