% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{strsimdata}
\alias{strsimdata}
\title{Structured Simulate Data sets}
\usage{
strsimdata(
  n = 100,
  WX = NULL,
  ncomp = 5,
  Xps = 10,
  Yps = FALSE,
  rho = 0.8,
  Ztype = c("none", "binary", "prob")[1],
  cz = c(1, 1),
  cwx = c(0.1, 0.1),
  cwy = c(0.1, 0.1),
  seed = 1,
  minpct = 0.25,
  maxpct = 0.75
)
}
\arguments{
\item{n}{a numeric scalar, sample size.}

\item{WX}{a matrix or a list, weights.}

\item{ncomp}{number of components}

\item{Xps}{a numeric vector, numbers of columns for X. The length of vector corresponds to the number of blocks.}

\item{Yps}{a numeric vector, numbers of columns for Y. The length of vector corresponds to the number of blocks.}

\item{rho}{a numeric, correlation}

\item{Ztype}{a character, outcome type ("none", "binary", "prob").}

\item{cz}{a numeric vector, scale for outcome}

\item{cwx}{a numeric vector, scale for weights of X}

\item{cwy}{a numeric vector, scale for weights of Y}

\item{seed}{a seed number for generating random numbers.}

\item{minpct}{minimum percent of nonzero}

\item{maxpct}{maximum percent of nonzero}
}
\value{
\item{X}{Simulated X which has a list form}

\item{Y}{Simulated Y which has a list form}

\item{Z}{Simulated Z which has a vector form}

\item{ncomp}{}

\item{Xps}{}

\item{nZeroX}{}

\item{idxZeroX}{}

\item{Yps}{}

\item{nZeroY}{}

\item{idxZeroY}{}

\item{WX}{}

\item{WY}{}

\item{ZcoefX}{}

\item{ZcoefY}{}
}
\description{
This is a function for generating multiblock data based on the multivariable normal distribusion
}
\details{
The output is a list of matrics.
}
