% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{msma}
\alias{msma}
\alias{msma.default}
\alias{print.msma}
\alias{plot.msma}
\title{Multiblock Sparse Partial Least Squares}
\usage{
msma(X, ...)

\method{msma}{default}(X, Y = NULL, Z = NULL, comp = 2,
  lambdaX = NULL, lambdaY = NULL, lambdaXsup = NULL,
  lambdaYsup = NULL, eta = 1, type = "lasso", inX = NULL,
  inY = NULL, inXsup = NULL, inYsup = NULL, muX = 0, muY = 0,
  defmethod = "canonical", scaling = TRUE, verbose = FALSE, ...)

\method{print}{msma}(x, ...)

\method{plot}{msma}(x, ...)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s).}

\item{...}{further arguments passed to or from other methods.}

\item{Y}{a (list of) matrix, objective variable(s). This is optional. If no input for Y, then the PCA method is complemented.}

\item{Z}{a (list of) matrix, response variable(s). This is optional. If no input for Z, then the unsupervised PLS/PCA is complemented.}

\item{comp}{numeric scalar for the maximum number of componets to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaXsup}{numeric vector of regularized parameters for the super weight of X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaYsup}{numeric vector of regularized parameters for the super weight of Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar the parameter indexing the penalty family.}

\item{type}{a character.}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of Y which are always in the model.}

\item{inXsup}{a (list of) numeric vector to specify the blocks of X which are always in the model.}

\item{inYsup}{a (list of) numeric vector to specify the blocks of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised.}

\item{muY}{a numeric scalar for the weight of Y for the supervised.}

\item{defmethod}{a character.}

\item{scaling}{a logical.}

\item{verbose}{information}

\item{x}{an object of class "\code{msma}", usually, a result of a call to \code{\link{msma}}}
}
\value{
\item{dmode}{Which modes "PLS" or "PCA"}

\item{X}{Scaled X which has a list form.}

\item{Y}{Scaled Y which has a list form.}

\item{Xscale}{Scaling information for X. The means and standard deviations for each block of X are returned.}

\item{Yscale}{Scaling information for Y. The means and standard deviations for each block of Y are returned.}

\item{comp}{the number of componets}

\item{wbX}{block loading for X}

\item{sbX}{block score for X}

\item{wbY}{block loading for Y}

\item{sbY}{block score for Y}

\item{ssX}{super score for X}

\item{wsX}{super loading for X}

\item{ssY}{super score for Y}

\item{wsY}{super loading for Y}

\item{nzwbX}{number of nonzeros in block loading for X}

\item{nzwbY}{number of nonzeros in block loading for Y}

\item{selectXnames}{names of selected variables for X}

\item{selectYnames}{names of selected variables for Y}
}
\description{
This is a function for computing partial least quares estimators from multivariate multiblock data incorporating sparse and supervised modeling
}
\details{
\code{msma} requires for two inputs, explanatory and objective variables.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component #####
fit1 = msma(X, Y, comp=1, lambdaX=2, lambdaY=1:3)
fit1

##### Two Component #####
fit2 = msma(X, Y, comp=2, lambdaX=2, lambdaY=1:3)
fit2

##### Matrix data #####
sigma = matrix(0.8, 10, 10)
diag(sigma) = 1
X2 = rmvnorm(50, rep(0, 10), sigma)
Y2 = rmvnorm(50, rep(0, 10), sigma)

fit3 = msma(X2, Y2, comp=1, lambdaX=2, lambdaY=2)
fit3

##### Sparse Principal Component Analysis #####
fit5 = msma(X2, comp=5, lambdaX=2.5)
summary(fit5)

}
