% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tumor_types.R
\name{get_tumor_types}
\alias{get_tumor_types}
\title{Get tumor types}
\usage{
get_tumor_types(oncotree_version = "oncotree_latest_stable")
}
\arguments{
\item{oncotree_version}{OncoTree version. Check available options with \code{\link[=get_versions]{get_versions()}}.}
}
\value{
A \link[tibble:tibble-package]{tibble} of 13 variables:
\describe{
\item{\code{oncotree_version}}{OncoTree tumor classification system version.}
\item{\code{oncotree_code}}{Tumor type code: a unique identifier for a tumor type within the classification system of the OncoTree.}
\item{\code{oncotree_name}}{Tumor type name: a brief description of the tumor type.}
\item{\code{oncotree_main_type}}{Tumor main type: a category under which the tumor type can be grouped.}
\item{\code{tissue}}{Tissue associated with the tumor type.}
\item{\code{level}}{OncoTree is a hierachical classification system with 5 levels. At the root level (level 0) there is the single \code{"TISSUE"} tumor type. At level 1, there are 32 tissue sites, e.g., \code{"BREAST"}.}
\item{\code{parent}}{The \code{parent} is the parent \code{oncotree_code} for this tumor type.}
\item{\code{umls_code}}{The corresponding tumor type identifier(s) in the Unified Medical Language System (UMLS).}
\item{\code{nci_code}}{The corresponding tumor type identifier(s) in the National Cancer Institute (NCI) Thesaurus.}
\item{\code{history}}{Previous tumor type codes (from previous OncoTree versions) used to identify this tumor type.}
\item{\code{revocations}}{TODO.}
\item{\code{precursors}}{TODO.}
\item{\code{color}}{Color associated with the tumor type.}
}
}
\description{
Get tumor types according to OncoTree's ontology.
}
\examples{
get_tumor_types()

}
