% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{msigdbr}
\alias{msigdbr}
\title{Retrieve msigdbr data frame.}
\usage{
msigdbr(species = "Homo sapiens", category = NULL, subcategory = NULL)
}
\arguments{
\item{species}{species name, such as Homo sapiens, Mus musculus, etc.}

\item{category}{collection, such as H, C1, C2, C3, C4, C5, C6, C7.}

\item{subcategory}{sub-collection, such as CGP, MIR, BP, etc.}
}
\value{
a data frame of gene sets with one gene per row
}
\description{
Retrieve msigdbr data frame.
}
\examples{
# all human gene sets
m = msigdbr(species = "Homo sapiens")

# mouse C2 (curated) CGP (chemical and genetic perturbations) gene sets
m = msigdbr(species = "Mus musculus", category = "C2", subcategory = "CGP")
}
