% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{as_bar_stack}
\alias{as_bar_stack}
\title{set a barchart as a stacked barchart}
\usage{
as_bar_stack(x, dir = "vertical", percent = FALSE, gap_width = 50)
}
\arguments{
\item{x}{an \code{\link{ms_barchart}} object}

\item{dir}{the direction of the bars in the chart, value must one of "horizontal" or "vertical".}

\item{percent}{should bars be in percent}

\item{gap_width}{gap width between the bar for each category on a bar chart, in percent
of the bar width. It can be set between 0 and 500.}
}
\description{
Apply settings to an \code{ms_barchart} object to
produce a stacked barchart. Options are available to use percentage
instead of values and to choose if bars should be vertically or horizontally drawn.
}
\examples{
library(officer)

my_bar_stack_01 <- ms_barchart(data = browser_data, x = "browser",
  y = "value", group = "serie")
my_bar_stack_01 <- as_bar_stack( my_bar_stack_01 )

my_bar_stack_02 <- ms_barchart(data = browser_data, x = "browser",
  y = "value", group = "serie")
my_bar_stack_02 <- as_bar_stack( my_bar_stack_02, percent = TRUE,
  dir = "horizontal" )

doc <- read_pptx()
doc <- add_slide(doc,
  layout = "Title and Content", master = "Office Theme")
doc <- ph_with_chart(doc, chart = my_bar_stack_01)
print(doc, target = "bar_stack.pptx")
}
