% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aenet.R
\name{aenet}
\alias{aenet}
\title{Adaptive Elastic-Net}
\usage{
aenet(
  x,
  y,
  family = c("gaussian", "binomial", "poisson", "cox"),
  init = c("enet", "ridge"),
  alphas = seq(0.05, 0.95, 0.05),
  tune = c("cv", "ebic", "bic", "aic"),
  nfolds = 5L,
  rule = c("lambda.min", "lambda.1se"),
  ebic.gamma = 1,
  scale = 1,
  lower.limits = -Inf,
  upper.limits = Inf,
  penalty.factor.init = rep(1, ncol(x)),
  seed = 1001,
  parallel = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector if \code{family} is \code{"gaussian"},
\code{"binomial"}, or \code{"poisson"}. If \code{family} is
\code{"cox"}, a response matrix created by \code{\link[survival]{Surv}}.}

\item{family}{Model family, can be \code{"gaussian"},
\code{"binomial"}, \code{"poisson"}, or \code{"cox"}.}

\item{init}{Type of the penalty used in the initial
estimation step. Can be \code{"enet"} or \code{"ridge"}.}

\item{alphas}{Vector of candidate \code{alpha}s to use in
\code{\link[glmnet]{cv.glmnet}}.}

\item{tune}{Parameter tuning method for each estimation step.
Possible options are \code{"cv"}, \code{"ebic"}, \code{"bic"},
and \code{"aic"}. Default is \code{"cv"}.}

\item{nfolds}{Fold numbers of cross-validation when \code{tune = "cv"}.}

\item{rule}{Lambda selection criterion when \code{tune = "cv"},
can be \code{"lambda.min"} or \code{"lambda.1se"}.
See \code{\link[glmnet]{cv.glmnet}} for details.}

\item{ebic.gamma}{Parameter for Extended BIC penalizing
size of the model space when \code{tune = "ebic"},
default is \code{1}. For details, see Chen and Chen (2008).}

\item{scale}{Scaling factor for adaptive weights:
\code{weights = coefficients^(-scale)}.}

\item{lower.limits}{Lower limits for coefficients.
Default is \code{-Inf}. For details, see \code{\link[glmnet]{glmnet}}.}

\item{upper.limits}{Upper limits for coefficients.
Default is \code{Inf}. For details, see \code{\link[glmnet]{glmnet}}.}

\item{penalty.factor.init}{The multiplicative factor for the penalty
applied to each coefficient in the initial estimation step. This is
useful for incorporating prior information about variable weights,
for example, emphasizing specific clinical variables. To make certain
variables more likely to be selected, assign a smaller value.
Default is \code{rep(1, ncol(x))}.}

\item{seed}{Random seed for cross-validation fold division.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is \code{FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the estimation progress?}
}
\value{
List of model coefficients, \code{glmnet} model object,
and the optimal parameter set.
}
\description{
Adaptive Elastic-Net
}
\examples{
dat <- msaenet.sim.gaussian(
  n = 150, p = 500, rho = 0.6,
  coef = rep(1, 5), snr = 2, p.train = 0.7,
  seed = 1001
)

aenet.fit <- aenet(
  dat$x.tr, dat$y.tr,
  alphas = seq(0.2, 0.8, 0.2), seed = 1002
)

print(aenet.fit)
msaenet.nzv(aenet.fit)
msaenet.fp(aenet.fit, 1:5)
msaenet.tp(aenet.fit, 1:5)
aenet.pred <- predict(aenet.fit, dat$x.te)
msaenet.rmse(dat$y.te, aenet.pred)
plot(aenet.fit)
}
\references{
Zou, Hui, and Hao Helen Zhang. (2009).
On the adaptive elastic-net with a diverging number of parameters.
\emph{The Annals of Statistics} 37(4), 1733--1751.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
