% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aenet.R
\name{aenet}
\alias{aenet}
\title{Adaptive Elastic-Net}
\usage{
aenet(x, y, family = c("gaussian", "binomial", "poisson", "multinomial",
  "cox", "mgaussian"), init = c("enet", "ridge"), nfolds = 5L,
  alphas = seq(0.05, 0.95, 0.05), gamma = 1, rule = c("lambda.min",
  "lambda.1se"), seed = 1001, parallel = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector.}

\item{family}{Response type.
See \code{\link[glmnet]{glmnet}} for details.}

\item{init}{Type of the penalty used in the initial
estimation step. Can be \code{"enet"} or \code{"ridge"}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{alphas}{Vector of candidate \code{alpha}s to use in
\code{\link[glmnet]{cv.glmnet}}.}

\item{gamma}{Scaling factor for adaptive weights:
\code{weights = coefs^(-gamma)}.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}} for details.}

\item{seed}{Random seed for cross-validation fold division.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the estimation progress?}
}
\value{
List of coefficients \code{beta} and
\code{glmnet} model object \code{model}.
}
\description{
Adaptive Elastic-Net
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

aenet.fit = aenet(dat$x.tr, dat$y.tr,
                  alphas = seq(0.2, 0.8, 0.2), seed = 1002)

print(aenet.fit)
msaenet.nzv(aenet.fit)
msaenet.fp(aenet.fit, 1:5)
msaenet.tp(aenet.fit, 1:5)
aenet.pred = predict(aenet.fit, dat$x.te)
msaenet.rmse(dat$y.te, aenet.pred)
plot(aenet.fit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\references{
Zou, Hui, and Hao Helen Zhang. (2009).
On the Adaptive Elastic-Net with a Diverging Number of Parameters.
\emph{The Annals of Statistics} 37(4), 1733--51.
}

