% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_rx.R
\name{ev_rx}
\alias{ev_rx}
\alias{ev_rx,mrgmod,character-method}
\alias{ev_rx,character,missing-method}
\alias{parse_rx}
\title{Create intervention objects from Rx input}
\usage{
ev_rx(x, y, ...)

\S4method{ev_rx}{mrgmod,character}(x, y, ...)

\S4method{ev_rx}{character,missing}(x, df = FALSE, ...)

parse_rx(x)
}
\arguments{
\item{x}{a model object or \code{character} Rx input}

\item{y}{\code{character} Rx input; see details}

\item{...}{not used at this time}

\item{df}{if \code{TRUE} then a data frame is returned}
}
\value{
The method dispatched on model object (\code{mrgmod}) returns another
model object.  The \code{character} method returns an event object.  The
\code{parse_rx} function return a list named with
arguments for the event object constructor \link{ev}.
}
\description{
See details below for Rx specification. Actual parsing is done
by \link{parse_rx}; this function can be used to debug Rx inputs.
}
\section{Rx specification}{

\itemize{
\item The dose is found at the start of the string by sequential digits; this
may be integer, decimal, or in scientific notation
\item Use \verb{in} to identify the dosing compartment number; must be integer
\item Use \code{q} to identify the dosing interval; must be integer or
decimal number (but not scientific notation)
\item Use \code{over} to indicate an infusion and its duration; integer or
decimal number
\item Use \code{x} to indicate total number of doses; must be integer
\item Use \code{then} or \verb{,} to separate dosing periods
\item User \code{after} to insert a lag in the start of a period; integer or
decimal number (but not scientific notation)
}
}

\examples{
# example("ev_rx")

ev_rx("100")

ev_rx("100 in 2")

ev_rx("100 q12 x 3")

ev_rx("100 over 2")

ev_rx("100 q 24 x 3 then 50 q12 x 2")

ev_rx("100 then 50 q 24 after 12")

ev_rx("100.2E-2 q4")

ev_rx("100 over 2.23")

ev_rx("100 q 12 x 3")

parse_rx("100 mg q 24 then 200 mg q12")

}
