% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_mrgmod.R
\docType{class}
\name{mrgmod-class}
\alias{mrgmod-class}
\title{S4 class for mrgsolve model object.}
\description{
S4 class for mrgsolve model object.
}
\section{Slots}{

\describe{
\item{\code{model}}{model name \code{<character>}}

\item{\code{project}}{working directory; must be writeable with no spaces \code{<character>}}

\item{\code{start}}{simulation start time \code{<numeric>}}

\item{\code{end}}{simulation end time \code{<numeric>}}

\item{\code{delta}}{simulation time interval \code{<numeric>}}

\item{\code{add}}{additional simulation times \code{<numeric-vector>}}

\item{\code{param}}{parameter_list}

\item{\code{fixed}}{a parameter_list of fixed value parameters; these are not updatable from \code{R}}

\item{\code{init}}{cmt_list}

\item{\code{events}}{\link[=ev]{events} object}

\item{\code{digits}}{significant digits in simulated output; negative integer means ignore \code{<numeric>}}

\item{\code{hmin}}{passed to dlsoda  \code{<numeric>}}

\item{\code{hmax}}{passed to dlsoda \code{<numeric>}}

\item{\code{mxhnil}}{passed to dlsoda \code{<numeric>}}

\item{\code{ixpr}}{passed to dlsoda \code{<numeric>}}

\item{\code{atol}}{passed to dlsoda \code{<numeric>}}

\item{\code{rtol}}{passed to dlsoda \code{<numeric>}}

\item{\code{maxsteps}}{passed to dlsoda \code{<numeric>}}

\item{\code{preclean}}{passed to R CMD SHLIB during compilation \code{<logical>}}

\item{\code{verbose}}{print run information to screen \code{<logical>}}

\item{\code{tscale}}{used to scale time in simulated output \code{<numeric>}}

\item{\code{omega}}{\code{\link{matlist}} for simulating individual-level random effects}

\item{\code{sigma}}{\code{\link{matlist}} for simulating residual error variates}

\item{\code{args}}{\code{<list>} of arguments to be passed to \code{\link{mrgsim}}}

\item{\code{advan}}{either 2, 4, or 13 \code{<numeric>}}

\item{\code{trans}}{either 1, 2, 4, or 11}

\item{\code{request}}{vector of compartments to request \code{<character>}}

\item{\code{soloc}}{directory path for storing the model shared object \code{<character>}}

\item{\code{code}}{a character vector of the model code}

\item{\code{mindt}}{minimum time between simulation records \code{<numeric>}}

\item{\code{envir}}{internal model environment \code{<environment>}}

\item{\code{annot}}{model annotations \code{<list>}}

\item{\code{plugin}}{model plugins \code{<character>}}
}}

\section{Notes}{

\itemize{
\item Spaces in paths (\code{project} and \code{soloc}) are prohibited.

}
}

