% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{within}
\alias{within}
\alias{within.mrgmod}
\alias{within,mrgmod-method}
\title{Update parameters, initials, and settings within a model object}
\usage{
\method{within}{mrgmod}(data, expr, ...)
}
\arguments{
\item{data}{an object with class mrgmod}

\item{expr}{expressions evaluated in an environment containing various model
object components, including parameters, initial conditions, and others
(see details)}

\item{...}{not used}
}
\description{
The main use case for using \link{within} rather than \link{update} or \link{param} or
\link{init} is when you want to update to a new value that is calculated from
the existing value.  See the example in details
}
\details{
Other model object slots that can be updated: \code{start}, \code{end}, \code{delta},
\code{add}, \code{rtol}, \code{atol}, \code{hmax}, \code{maxsteps}.  These are include for convenience,
but we expect that most of the time these will get updated through the
update method.
}
\examples{
mod <- mrgsolve::house()

mod2 <- within(mod, {CL <- CL * 1.5})

mod$CL
mod2$CL

}
\seealso{
\link{update}
}
