% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\docType{methods}
\name{update}
\alias{update}
\alias{update,mrgmod-method}
\alias{update,omegalist-method}
\alias{update,sigmalist-method}
\alias{update,parameter_list-method}
\alias{update,ev-method}
\title{Update the model object}
\usage{
\S4method{update}{mrgmod}(object, ..., merge = TRUE, open = FALSE,
  data = NULL, strict = TRUE)

\S4method{update}{omegalist}(object, y, ...)

\S4method{update}{sigmalist}(object, y, ...)

\S4method{update}{parameter_list}(object, .y, ...)

\S4method{update}{ev}(object, y, ...)
}
\arguments{
\item{object}{a model object}

\item{...}{named items to update}

\item{merge}{logical indicating to merge (rather than replace) 
new and existing attributes}

\item{open}{logical; used only when merge is \code{TRUE} and 
parameter list or initial conditions
list is being updated; if \code{FALSE}, no new items will be 
added; if \code{TRUE}, the parameter list may expand.}

\item{data}{a list of items to update; this list is combined 
with any items passed in via \code{...}}

\item{strict}{if \code{TRUE}, then an error will be generated if there is 
attempt to update a non-existent item}

\item{y}{another object involved in update}

\item{.y}{data to update}
}
\value{
The updated model object is returned.
}
\description{
After the model object is created, update various attributes.
}
\details{
Slots that can be updated: 

\itemize{
\item verbose
\item debug
\item preclean
\item mindt
\item digits
\item atol - absolute solver tolerance; see \code{\link{solversettings}}
\item rtol - relative solver tolerance; see \code{\link{solversettings}}
\item ixpr - see \code{IXPR} in \code{\link{solversettings}}
\item mxhnil - see \code{MXHNIL} in \code{\link{solversettings}}
\item hmin - see \code{HMIN} in \code{\link{solversettings}}
\item hmax - see \code{HMAX} in \code{\link{solversettings}}
\item maxsteps - see \code{MXSTEP} in \code{\link{solversettings}}
\item start, end, delta, add
\item tscale
\item request
\item param
\item init
\item omega
\item sigma
\item outvars
}
}
\examples{
\dontrun{
 mod <- mrgsolve:::house()

 mod <- update(mod, end=120, delta=4, param=list(CL=19.1))
}
 
}
\seealso{
\code{\link{update}}, \code{\link{mrgmod-class}}
}
