% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ds.R
\name{plot.ds}
\alias{plot.ds}
\title{Plot fit of detection functions and histograms of data from distance sampling model}
\usage{
\method{plot}{ds}(
  x,
  which = 2,
  breaks = NULL,
  nc = NULL,
  jitter.v = rep(0, 3),
  showpoints = TRUE,
  subset = NULL,
  pl.col = "lightgrey",
  pl.den = NULL,
  pl.ang = NULL,
  main = NULL,
  pages = 0,
  pdf = FALSE,
  ylim = NULL,
  xlab = "Distance",
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{fitted model from \code{ddf}.}

\item{which}{index to specify which plots should be produced:
\tabular{ll}{1 \tab histogram of observed distances\cr
             2 \tab histogram of observed distances with fitted line and points (default)\cr}}

\item{breaks}{user defined breakpoints}

\item{nc}{number of equal width bins for histogram}

\item{jitter.v}{apply jitter to points by multiplying the fitted value by a random draw from a normal distribution with mean 1 and sd \code{jitter.v}.}

\item{showpoints}{logical variable; if \code{TRUE} plots predicted value for each observation (conditional on its observed distance).}

\item{subset}{subset of data to plot.}

\item{pl.col}{colour for histogram bars.}

\item{pl.den}{shading density for histogram bars.}

\item{pl.ang}{shading angle for histogram bars.}

\item{main}{plot title.}

\item{pages}{the number of pages over which to spread the plots. For example, if \code{pages=1} then all plots will be displayed on one page. Default is 0, which prompts the user for the next plot to be displayed.}

\item{pdf}{plot the histogram of distances with the PDF of the probability of detection overlaid. Ignored (with warning) for line transect models.}

\item{ylim}{vertical axis limits.}

\item{xlab}{horizontal axis label (defaults to "Distance").}

\item{ylab}{vertical axis label (default automatically set depending on plot type).}

\item{\dots}{other graphical parameters, passed to the plotting functions (\code{\link{plot}}, \code{\link{hist}}, \code{\link{lines}}, \code{\link{points}}, etc).}
}
\value{
Just plots.
}
\description{
Plots the fitted detection function(s) with a histogram of the observed distances to compare visually the fitted model and data.
}
\details{
The structure of the histogram can be controlled by the user-defined arguments \code{nc} or \code{breaks}. The observation specific detection probabilities along with the line representing the fitted average detection probability.

It is not intended for the user to call \code{plot.ds} but its arguments are documented here. Instead the generic \code{plot} command should be used and it will call the appropriate function based on the class of the \code{ddf} object.
}
\examples{
\donttest{
# fit a model to the tee data
data(book.tee.data)
egdata <- book.tee.data$book.tee.dataframe
xx <- ddf(dsmodel=~mcds(key="hn", formula=~sex),
          data=egdata[egdata$observer==1, ],
          method="ds", meta.data=list(width=4))

# not showing predicted probabilities
plot(xx, breaks=c(0, 0.5, 1, 2, 3, 4), showpoints=FALSE)

# two subsets
plot(xx, breaks=c(0, 0.5, 1, 2, 3, 4), subset=sex==0)
plot(xx, breaks=c(0, 0.5, 1, 2, 3, 4), subset=sex==1)

# put both plots on one page
plot(xx, breaks=c(0, 0.5, 1, 2, 3, 4), pages=1, which=1:2)
}
}
\seealso{
add_df_covar_line
}
\author{
Jeff Laake, Jon Bishop, David Borchers, David L Miller
}
\keyword{plot}
