% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trial.fi.R
\name{plot.trial.fi}
\alias{plot.trial.fi}
\title{Plot fit of detection functions and histograms of data from distance
sampling trial observer model}
\usage{
\method{plot}{trial.fi}(
  x,
  which = 1:2,
  breaks = NULL,
  nc = NULL,
  maintitle = "",
  showlines = TRUE,
  showpoints = TRUE,
  ylim = c(0, 1),
  angle = NULL,
  density = NULL,
  col = "lightgrey",
  jitter = NULL,
  divisions = 25,
  pages = 0,
  xlab = "Distance",
  ylab = "Detection probability",
  subtitle = TRUE,
  ...
)
}
\arguments{
\item{x}{fitted model from \code{ddf}}

\item{which}{index to specify which plots should be produced.
\tabular{ll}{1 \tab Unconditional detection function for observer 1 \cr
             2 \tab Conditional detection function plot (1|2)\cr}}

\item{breaks}{user define breakpoints}

\item{nc}{number of equal-width bins for histogram}

\item{maintitle}{main title line for each plot}

\item{showlines}{logical variable; if \code{TRUE} a line representing the average
detection probability is plotted}

\item{showpoints}{logical variable; if \code{TRUE} plots predicted value for each
observation}

\item{ylim}{range of vertical axis; defaults to (0,1)}

\item{angle}{shading angle for histogram bars.}

\item{density}{shading density for histogram bars.}

\item{col}{colour for histogram bars.}

\item{jitter}{scaling option for plotting points. Jitter is applied to
points by multiplying the fitted value by a random draw from a normal
distribution with mean 1 and sd jitter.}

\item{divisions}{number of divisions for averaging line values; default = 25}

\item{pages}{the number of pages over which to spread the plots. For
example, if \code{pages=1} then all plots will be displayed on one page.
Default is 0, which prompts the user for the next plot to be displayed.}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{subtitle}{if TRUE, shows plot type as sub-title}

\item{\dots}{other graphical parameters, passed to the plotting functions
(\code{plot}, \code{hist}, \code{lines}, \code{points}, etc)}
}
\description{
Plots the fitted detection functions for a distance sampling model and
histograms of the distances (for unconditional detection functions) or
proportion of observations detected within distance intervals (for
conditional detection functions) to compare visually the fitted model and
data.
}
\details{
The structure of the histogram can be controlled by the user-defined
arguments \code{nc} or \code{breaks}.  The observation specific detection
probabilities along with the line representing the fitted average detection
probability.

It is not intended for the user to call \code{plot.io.fi} but its arguments
are documented here. Instead the generic \code{plot} command should be used
and it will call the appropriate function based on the class of the
\code{ddf} object.
}
\author{
Jeff Laake, Jon Bishop, David Borchers
}
\keyword{plot}
