% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{ptdata.dual}
\alias{ptdata.dual}
\title{Simulated dual observer point count data}
\format{The format is 420 obs of 6 variables:
distance: numeric distance from center
observer: Factor w/ 2 levels "1","2": 1 2 1 2 1 2 1 2 1 2 ...
detected: numeric 0/1
person: Factor with 2 levels A,B
pair: Factor with 2 levels "AB" BA" $
object : sequential object number}
\description{
Simulated dual observer point count data with detection p(0)=0.8;
hn sigma=30; w=100 for both observers with dependency y>0, gamma=0.1
}
\examples{
\donttest{
data(ptdata.dual)
xx <- ddf(mrmodel=~glm(formula=~distance),
          dsmodel = ~cds(key="hn", formula = ~1),
          data = ptdata.dual, method = "io", meta.data = list(point=TRUE))
summary(xx)
plot(xx,main="Simulated point count data")
}
}
\keyword{datasets}

