% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.io.fi.R
\name{plot.io.fi}
\alias{plot.io.fi}
\title{Plot fit of detection functions and histograms of data from distance
sampling independent observer model with full independence (\code{io.fi})}
\usage{
\method{plot}{io.fi}(x, which = 1:6, breaks = NULL, nc = NULL,
  maintitle = "", showlines = TRUE, showpoints = TRUE, ylim = c(0, 1),
  angle = -45, density = 20, col = "black", jitter = NULL,
  divisions = 25, pages = 0, xlab = "Distance",
  ylab = "Detection probability", subtitle = TRUE, ...)
}
\arguments{
\item{x}{fitted model from \code{ddf}}

\item{which}{index to specify which plots should be produced.
\tabular{ll}{1 \tab Plot primary unconditional detection function \cr
             2 \tab Plot secondary unconditional detection function \cr
             3 \tab Plot pooled unconditional detection function \cr
             4 \tab Plot duplicate unconditional detection function \cr
             5 \tab Plot primary conditional detection function \cr
             6 \tab Plot secondary conditional detection function \cr}
Note that the order of which is ignored and plots are produced in the above
order.}

\item{breaks}{user define breakpoints}

\item{nc}{number of equal-width bins for histogram}

\item{maintitle}{main title line for each plot}

\item{showlines}{logical variable; if TRUE a line representing the average
detection probability is plotted}

\item{showpoints}{logical variable; if TRUE plots predicted value for each
observation}

\item{ylim}{range of y axis; defaults to (0,1)}

\item{angle}{shading angle for hatching}

\item{density}{shading density for hatching}

\item{col}{plotting colour}

\item{jitter}{scaling option for plotting points.  Jitter is applied to
points by multiplying the fitted value by a random draw from a normal
distribution with mean 1 and sd jitter.}

\item{divisions}{number of divisions for averaging line values; default = 25}

\item{pages}{the number of pages over which to spread the plots. For
example, if \code{pages=1} then all plots will be displayed on one page.
Default is 0, which prompts the user for the next plot to be displayed.}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{subtitle}{if TRUE, shows plot type as sub-title}

\item{\dots}{other graphical parameters, passed to the plotting functions
(\code{plot}, \code{hist}, \code{lines}, \code{points}, etc)}
}
\value{
Just plots.
}
\description{
Plots the fitted detection functions for a distance sampling model and
histograms of the distances (for unconditional detection functions) or
proportion of observations detected within distance intervals (for
conditional detection functions) to compare visually the fitted model and
data.
}
\details{
The structure of the histogram can be controlled by the user-defined
arguments \code{nc} or \code{breaks}.  The observation specific detection
probabilities along with the line representing the fitted average detection
probability.

It is not intended for the user to call \code{plot.io.fi} but its arguments
are documented here. Instead the generic \code{plot} command should be used
and it will call the appropriate function based on the class of the
\code{ddf} object.
}
\examples{
\donttest{
library(mrds)
data(book.tee.data)
egdata <- book.tee.data$book.tee.dataframe
result.io.fi <- ddf(mrmodel=~glm(~distance), data = egdata, method = "io.fi",
              meta.data = list(width = 4))

# just plot everything
plot(result.io.fi)

# Plot primary and secondary unconditional detection functions on one page
# and  primary and secondary conditional detection functions on another
plot(result.io.fi,which=c(1,2,5,6),pages=2)
}
}
\author{
Jeff Laake, Jon Bishop, David Borchers, David L Miller
}
\keyword{plot}

