% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{plotMultiNMR}
\alias{plotMultiNMR}
\title{A function for plotting NMR spectra.}
\usage{
plotMultiNMR(
  region = NULL,
  rectangleRegions = NULL,
  rectangleColors = c("darkseagreen3", "orange", "blue", "red", "yellow", "gray",
    "purple"),
  rectangleColors2D = NULL,
  density = NULL,
  angles = 35,
  cex.axis = 0.7,
  rectangleFront = FALSE,
  correctOffset2D = TRUE,
  polygonRegion = NULL,
  maxPlots = Inf,
  setContours = TRUE,
  color = NULL,
  add = FALSE,
  showGrid = FALSE,
  buffer = TRUE,
  manualScale = TRUE,
  plotTitle = "",
  renewSpectrum = TRUE,
  restrictToRange = FALSE,
  enableSplit = TRUE,
  dimension = NULL,
  lwd = 1,
  background = NULL,
  titles = NULL,
  plotCurrent = TRUE,
  ...
)
}
\arguments{
\item{region}{A vector defining the plot region (left, right, top, bottom) or "all" for the whole spectrum}

\item{rectangleRegions}{A 4-column matrix defining areas where to plot rectangles}

\item{rectangleColors}{Define colors for the rectangles}

\item{rectangleColors2D}{Define colors for rectangles in 2D spectra. If NULL, defaults to the same as rectangleColors}

\item{density}{Shading lines for the rectangles}

\item{angles}{Angles of shading lines for the rectangles}

\item{cex.axis}{Font size of axis tick labels.}

\item{rectangleFront}{Plot rectangles in front of spectrum rather than in background (only 2D)}

\item{correctOffset2D}{Do a basic offset correction so 2D spectra have a baseline close to 0. Defaults to TRUE}

\item{polygonRegion}{Defines 4 corners of a polygon to be plotted}

\item{maxPlots}{The maximum number of 2D plots to be overlaid}

\item{setContours}{Should upper and lower contour levels be calculated of the old ones be reused? Default: TRUE}

\item{color}{Defines the color of the spectrum plot. If NULL, a rainbow theme is used for 2D NMR}

\item{add}{If TRUE, additional spectrum plots are overlaid with the current plot}

\item{showGrid}{Shows a grid of data points. Defaults to FALSE}

\item{buffer}{Speed up plotting by loading a plot. Defaults to TRUE}

\item{manualScale}{If TRUE, scaling factor is taken from environment variables}

\item{plotTitle}{Defines the main title of the plot}

\item{renewSpectrum}{Should a new size-reduced spectrum for quicker plotting be calculated, or can the old one be used? Default: TRUE}

\item{restrictToRange}{Restrict plot area to range of available data points. Defaults to FALSE}

\item{enableSplit}{Allow split plots for showing 1D and 2D spectra simultaneously}

\item{dimension}{If not provided, this will be taken from package environment}

\item{lwd}{Line width, defaults to 1}

\item{background}{Background color, defaults to NULL (no background fill, usually results in a white background)}

\item{titles}{Display list of spectrum titles in plot, defaults to NULL}

\item{plotCurrent}{Should the first (current) spectrum in the list be plotted, defaults to TRUE}

\item{...}{Additional graphical parameters that will be passed to the functions plot, lines, and/or contour}
}
\value{
{None}
}
\description{
This function plots the current NMR spectrum. If no parameters are provided, parameters
are read from the mrbin.env environment variables, set by mrbin.
To change the plot, use zoom(),
zoomIn(), zoomOut(), intPlus(), intMin(), left(), right().
For 2D data use additionally: contMin(), contPlus(), up(), down()
}
\examples{
mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",binwidth1D=.1,
         PQNScaling="No",noiseRemoval="No",trimZeros="No",tryParallel=TRUE,
         fixNegatives="No",logTrafo="No",PCA="No",verbose=TRUE,
         NMRfolders=system.file("extdata/1/10/pdata/10",package="mrbin")))
plotMultiNMR()
}
