% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_R2_GE.R
\name{QTL_R2_GE}
\alias{QTL_R2_GE}
\title{MPP GxE QTL R2}
\usage{
QTL_R2_GE(mppData, trait, QTL = NULL, glb.only = FALSE)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{trait}{\code{Character vector} specifying which traits (environments) should be used.}

\item{QTL}{Object of class \code{QTLlist} representing a list of
selected marker positions obtained with the function QTL_select() or
a vector of \code{character} marker positions names. Default = NULL.}

\item{glb.only}{\code{Logical} value. If glb.only = TRUE, only the global and
global adjusted R squared will be returned. Default = FALSE.}
}
\value{
Return:

\code{List} containing the global unadjusted R2, the global adjusted R2,
the partial unadjusted R2, and the partial adjusted R2.
}
\description{
Compute global and partial R2 statistics for MPP GxE QTL using a linear model.
The global R2 is the contribution of all QTL positions while the partial R2
is the specific contribution of an individual QTL position.
}
\examples{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

R2 <- QTL_R2_GE(mppData = mppData_GE, trait = c('DMY_CIAM', 'DMY_TUM'),
                QTL = Qpos)

}
\author{
Vincent Garin
}
