% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBS.mppData.R
\name{IBS.mppData}
\alias{IBS.mppData}
\title{IBS coding for \code{mppData} objects}
\usage{
IBS.mppData(mppData)
}
\arguments{
\item{mppData}{An object of class \code{mppData}. The \code{mppData} must
have been processed using: \code{\link{create.mppData}} and
\code{\link{QC.mppData}}.}
}
\value{
an increased \code{mppData} object containing the the same elements
as the \code{mppData} object provided as argument and the
following new elements:

\item{geno.IBS}{Marker \code{matrix} with marker scores coded as 0, 1, 2
corresponding to the number of copies of the least frequent SNP allele.}

\item{allele.ref}{\code{matrix} with reference allele scores. The first row
represents the minor allele (lowest frequency), the second the one represent
the major allele (largest frequency) and the two others the heterozygous
scores.}
}
\description{
Transform the genotype marker matrix of a \code{mppData} object into
Identical by state (IBS) 0, 1, 2 format. The IBS score represent the number
of copies of the minor allele.
}
\examples{

data(mppData_init)

mppData <- QC.mppData(mppData_init)

mppData <- IBS.mppData(mppData = mppData)
      

}
\seealso{
\code{\link{create.mppData}}, \code{\link{QC.mppData}}
}
\author{
Vincent Garin
}
