#' @import qtl
#' @importFrom igraph plot.igraph V E "E<-" graph.empty vertices edges layout.reingold.tilford
#' @import methods
#' @import utils
#' @import ggplot2
#' @import graphics
#' @importFrom progress progress_bar
#' @importFrom graphics plot
#' @importFrom grDevices dev.off pdf
#' @importFrom stats as.dist cutree pchisq rnorm cor manova na.omit pf
#' @importFrom car linearHypothesis
#' @importFrom utils combn head tail
#' @importFrom pryr address
#' @importFrom fastcluster hclust
#' @importFrom nnls nnls
#' @importFrom ggplot2 ggplot
#' @importFrom RColorBrewer brewer.pal
#' @exportClass pedigreeGraph
#' @exportClass probabilities
#' @exportMethod subset 
#' @exportClass mpcross
#' @exportClass pedigreeGraph
#' @exportMethod imputationMap
#' @exportMethod plot
#' @exportMethod flatImputationMapNames
#' @importClassesFrom Matrix index dspMatrix dppMatrix
#' @importFrom methods setClass
#' @importFrom jsonlite toJSON
#' @importClassesFrom sn SECdistrMv
#' @importFrom stats lm contrasts<-
#' @importFrom sn dmst extractSECdistr selm
#' @importMethodsFrom sn plot
#' @importFrom igraph max_cliques graph_from_adjacency_matrix
#' @useDynLib mpMap2
NULL

#' @name simulatedFourParentData
#' @title Simulated data from a four-parent population. 
#' @rdname simulatedFourParentData
#' @docType data
#' @description Simulated data from a four-parent population. Used in the examples given in the documentation.
#' @examples
#' set.seed(1)
#' #This data was generated by the following script
#' pedigree <- fourParentPedigreeRandomFunnels(initialPopulationSize = 1000,
#'      selfingGenerations = 6, intercrossingGenerations = 0)
#' #Assume infinite generations of selfing in subsequent analysis
#' selfing(pedigree) <- "infinite"
#' #Generate random map
#' simulatedFourParentMap <- qtl::sim.map(len = 100, n.mar = 101, anchor.tel = TRUE, 
#' 	include.x = FALSE)
#' #Simulate data
#' simulatedFourParentData <- simulateMPCross(map = simulatedFourParentMap, pedigree = pedigree, 
#' 	mapFunction = haldane, seed = 1L)
NULL
#' @name simulatedFourParentMap
#' @rdname simulatedFourParentData
NULL

#' @name eightParentSubsetMap
#' @title Genetic map and genetic data from an 8-parent MAGIC population. 
#' @docType data
#' @author Alex Whan, Matthew Morell, Rohan Shah, Colin Cavanagh
#' This dataset contains the genetic map, genetic data, and imputed IBD genotypes for parts of chromosomes 1A, 1B and 1D, from an 8-way MAGIC population of 4229 lines.
NULL

#' @name wsnp_Ku_rep_c103074_89904851
#' @rdname wsnp_Ku_rep_c103074_89904851
#' @title Raw genotyping data for marker wsnp_Ku_rep_c103074_89904851
#' @docType data
#' @author Alex Whan, Matthew Morell, Rohan Shah, Colin Cavanagh
#' This dataset contains the raw genotyping data for marker wsnp_Ku_rep_c103074_89904851. This marker is interesting, because it can be mapped to both chromosome 1B (four alleles) and 1D (two alleles). 
#' @examples
#' data(eightParentSubsetMap)
#' data(wsnp_Ku_rep_c103074_89904851)
#' data(callFromMapExampleLocalisationStatistics)
#' called <- callFromMap(rawData = as.matrix(wsnp_Ku_rep_c103074_89904851), existingImputations = 
#'     eightParentSubsetMap, useOnlyExtraImputationPoints = TRUE, tDistributionPValue = 0.8, 
#'     thresholdChromosomes = 80, existingLocalisationStatistics = existingLocalisationStatistics)
#' library(ggplot2)
#' library(gridExtra)
#' plotData <- wsnp_Ku_rep_c103074_89904851
#' plotData$genotype1B <- factor(called$classificationsPerPosition$Chr1BLoc31$finals)
#' plotData$imputed1B <- factor(imputationData(eightParentSubsetMap)[, "Chr1BLoc31"])
#' plotData$genotype1D <- factor(called$classificationsPerPosition$Chr1DLoc16$finals)
#' plotData$imputed1D <- factor(imputationData(eightParentSubsetMap)[, "Chr1DLoc16"])
#' 
#' plotImputations1B <- ggplot(plotData, mapping = aes(x = theta, y = r, color = imputed1B)) + 
#'     geom_point() + theme_bw() + ggtitle("Imputed genotype, 1B") + 
#'     guides(color=guide_legend(title="IBD genotype"))
#' 
#' called1B <- ggplot(plotData, mapping = aes(x = theta, y = r, color = genotype1B)) + 
#'     geom_point() + theme_bw() + ggtitle("Called genotype, 1B") + 
#'     guides(color=guide_legend(title="Called cluster")) + scale_color_manual(values = 
#'     c("black", RColorBrewer::brewer.pal(n = 4, name = "Set1")))
#' 
#' plotImputations1D <- ggplot(plotData, mapping = aes(x = theta, y = r, color = imputed1D)) + 
#'     geom_point() + theme_bw() + ggtitle("Imputed genotype, 1D") + 
#'     guides(color=guide_legend(title="IBD genotype"))
#' 
#' called1D <- ggplot(plotData, mapping = aes(x = theta, y = r, color = genotype1D)) + 
#'     geom_point() + theme_bw() + ggtitle("Called genotype, 1D") + 
#'     guides(color=guide_legend(title="Called cluster")) + 
#'     scale_color_manual(values = c("black",RColorBrewer::brewer.pal(n=3,name = "Set1")[1:2]))
#' 
#' \dontrun{grid.arrange(plotImputations1B, plotImputations1D, called1B, called1D)}
NULL

#' @name existingLocalisationStatistics
#' @rdname existingLocalisationStatistics
#' @title Localisation statistics for example of callFromMap
#' @docType data
#' @description
#' This dataset contains the localisation statistics for the example for running \code{callFromMap}. This makes the example fast enough to pass the CRAN check. 
NULL
