% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_move.R
\name{animate_move}
\alias{animate_move}
\title{Animate movement data}
\usage{
animate_move(data_ani, out_dir, conv_dir = "convert", layer = "basemap",
  layer_dt = "basemap", layer_int = FALSE, layer_type = "",
  layer_col = c("sandybrown", "white", "darkgreen"), layer_nacol = "white",
  map_type = "satellite", extent_factor = 1e-04, tail_elements = 10,
  tail_size = 4, img_title = "title", img_sub = "subtitle",
  img_caption = "caption", img_labs = "labs", legend_title = "",
  legend_limits = NA, legend_labels = "auto", map_elements = TRUE,
  scalebar_col = "white", north_col = "white", paths_col = "auto",
  paths_alpha = 1, paths_mode = "true_data", stats_create = FALSE,
  frames_nmax = 0, frames_interval = 0.04, frames_nres = 1,
  frames_width = NA, frames_height = NA, out_name = "final_gif",
  log_level = 1, log_logical = FALSE, ...)
}
\arguments{
\item{data_ani}{list or \code{moveStack} class object. Needs to contain one or several \code{move} class objects (one for each individual path to be displayed) containing point coordinates, timestamps and projection.}

\item{out_dir}{character. Output directory for the GIF file creation.}

\item{conv_dir}{character. Command or directory to call the ImageMagick convert tool (default to be \code{convert}). You can use \code{conv_dir = get_imconvert()} to search for the right command/tool directory and/or get the required software.}

\item{layer}{raster, list or character. Single raster object or list of raster objects to be used as (dynamically changing) basemap layer. Default is \code{"basemap"} to download a static basemap layer. Use a rasterBrick class object and set layer_type to "\code{RGB}" to compute a RGB basemap.}

\item{layer_dt}{POSIXct or list. Single POSIXct date/time stamp or list of POSIXct date/time stamps corresponding to the acquisition dates of the \code{layer} raster objects.}

\item{layer_int}{logical. Whether to interpolate the basemap layer objects over time, if several are provided (\code{TRUE}), or to display them one after another depending on the animation time frame that is displayed (\code{FALSE}). Default is \code{FALSE}.}

\item{layer_type}{charachter. Layer type. Can be either "\code{RGB}" (if layer is a rasterBrick class onejct), "\code{gradient}" or "\code{discrete}". Default is "\code{RGB}". Ignored, if \code{layer = "basemap"}.}

\item{layer_col}{character vector.  Two or more colours to be used for displaying the background layer. If \code{layer_type = "gradient"}, a colour ramp between the colous is calcualted. If \code{layer_type = "discrete"}, the colours will be used per value range. Ignored, if \code{layer_type = "RGB"}.}

\item{layer_nacol}{character. Colour to be displayed for NA values. Default is "white".}

\item{map_type}{character.  Static basemap type. Chosse from "roadmap", "satellite", "hybrid", "terrain".}

\item{extent_factor}{numeric. Defines the distance between the spatial extents of the movement data set and the basemap as proportion of the axis distance. Default is 0.0001. The higher the value, the larger the basemap extent. Ignored, if \code{layer} = "basemap".}

\item{tail_elements}{numeric. Number of points to be displayed as path tail of the animation paths. Default is 10.}

\item{tail_size}{numeric. Size of the first tail element. Default is 4.}

\item{img_title}{character. Titel to be displayed above the animated plot. If not specified, no title will be displayed.}

\item{img_sub}{character. Subtitel to be displayed underneath the title. If not specified, no subtitle will be displayed.}

\item{img_caption}{character. Caption to be displayed underneath the plot. If not specified, no caption will be displayed.}

\item{img_labs}{character. Axis titles to be displayed at the x and y axis of the plot. If not specified, labs will be computed depending on the projection or will be "x" and "y".}

\item{legend_title}{character. Title to be displayed above the basemap layer legend (if layer_type is not \code{"RGB"}). Ignored, if \code{layer = "basemap"}.}

\item{legend_limits}{numeric vector. Fixed minimum and maximum limit values of the legend (gradient layer type). Default is NA for data-depending minimum and maximum values. Ignored, if \code{layer_type} is "discrete" or "RGB".}

\item{legend_labels}{character vectors. Label for each legend break class. If set to "auto", values are displayed. Default is "auto".}

\item{map_elements}{logical. If \code{FALSE}, map elements (north arrow and scale bar) are hidden. Default is \code{TRUE}.}

\item{scalebar_col}{character. Colour of the scalebar text. Default is "white".}

\item{north_col}{character. Colour of the north arrow. Default is "white".}

\item{paths_col}{character vector. Colours of the individual animation paths. If set to "auto", a predfined colour set will be used. If single colour, all paths will be displayed by the same colour. If more individuals then colours, the colours are repeated.}

\item{paths_alpha}{numeric. Set transparency of pathes. If set to 0, path is invisible. Default is 1.}

\item{paths_mode}{character vector. Mode to be used for dealing with time information when displaying multiple individual paths. If set to "true_data", paths are displayed based on true coverage times, showing only time periods that are covered. Time gaps will be skipped. Each frame is linked to a specific true time. If set to "true_time",  paths are displayed based on true coverage times. Time gaps will be filled with non-movement frames. This mode is only recommended, if the dataset has no time gaps. Each frame is linked to a specific, true time. If set to "simple", all movement paths are displayed individually with no regard to the true coverage times. Time gaps will be skipped. Each frame displays several times at once, since each individual path has its own time. Default is "true_data".}

\item{stats_create}{logical. \code{TRUE} to create statistic plots side by side with the spatial plot. Use the arguments explained for \code{\link{animate_stats}} to adjust the plotting behaviour. Default is \code{FALSE}.}

\item{frames_nmax}{numeric. Number of maximum frames. If set, the animation will be stopped, after the specified number of frames is reached. Default is 0 (displaying all frames).}

\item{frames_interval}{numeric. Duration, each frame is displayed (in seconds). Default is .04.}

\item{frames_nres}{numeric. Interval of which frames of all frames should be used (nth elements). Default is 1 (every frame is used). If set to 2, only every second frame is used.}

\item{frames_width}{numeric. Number of pixels of frame width. Default is 600 (with stats plots 1000).}

\item{frames_height}{numeric. Number of pixels of frame height. Defualt is 600.}

\item{out_name}{character. Name of the output file. Default is "final_gif".}

\item{log_level}{numeric. Level of console output given by the function. There are three log levels. If set to 3, no messages will be displayed except erros that caused an abortion of the process. If set to 2, warnings and errors will be displayed. If set to 1, a log showing the process activity, wanrnings ans errors will be displayed.}

\item{log_logical}{logical. For large processing schemes. If \code{TRUE}, the function returns \code{TRUE} when finished processing succesfully.}

\item{...}{optional arguments. All arguments taken by \code{\link{animate_stats}} can be handed over to \code{\link{animate_move}} as well to create sidy-by-side spatial and statistic plot animations (see \code{\link{animate_stats}}).}
}
\value{
None or logical (see \code{log_logical}. The output GIF file is written to the ouput directory.
}
\description{
\code{animate_move} animates movement data provided as \code{move} class objects or a list of them. The function creates an animated GIF file and saves it into the output directory. \code{animate_move} can be operated in different timing modes (see \code{paths_mode}) and with different background layer types (see \code{layer}, \code{layer_type} and \code{map_type}).
}
\details{
\code{animate_move} is based on \code{ggplot2} and partly based on the \code{animation} package. It needs the \code{convert} tool of the \code{ImageMagick} software package to assemble GIF files. The command or directory to the convert tool needs to be provided with \code{conv_dir}. Please use \code{\link{get_imconvert}} to search for the convert command/tool directory on your system or to automatically download and install the required software. See \code{\link{get_imconvert}} for details.
}
\examples{
#Load move and moveVis packages
library(move)
library(moveVis)

#Get the sample data from the moveVis package
data("move_data")
move_data$dt <- as.POSIXct(strptime(move_data$dt, "\%Y-\%m-\%d \%H:\%M:\%S", tz = "UTC"))

#Differentiate data per individual
indi_levels <- levels(move_data$individual)
indi_levels_n <- length(indi_levels)
for(i in 1:indi_levels_n){
  if(i == 1){
    indi_subset <- list(subset(move_data, individual == indi_levels[i]))
  }else{
    indi_subset <- c(indi_subset,list(subset(move_data,
                               individual == indi_levels[i])))
  }
}
indi_names <- paste(indi_levels, collapse = ", ")

#Create move class object
for(i in 1:length(indi_subset)){
  if(i == 1){
     data_ani <- list(move(x=indi_subset[[i]]$lon,y=indi_subset[[i]]$lat,
                                 time=indi_subset[[i]]$dt,
                                 proj=CRS("+proj=longlat +ellps=WGS84"),
                                 animal=indi_levels[i]))
  }else{
     data_ani[i] <- list(move(x=indi_subset[[i]]$lon,y=indi_subset[[i]]$lat,
                                 time=indi_subset[[i]]$dt,
                                 proj=CRS("+proj=longlat +ellps=WGS84"),
                                 animal=indi_levels[i]))}
}

#Find command or directory to convert tool of ImageMagick
conv_dir <- get_imconvert()

#Specify output directory
out_dir <- "/out/test"

#Specify some optional appearance variables
img_title <- "Movement of the white stork population at Lake Constance, Germany"
img_sub <- paste0("including individuals ",indi_names)
img_caption <- "Projection: Geographical, WGS84; Sources: Movebank 2013; Google Maps"

#Call animate_move()
animate_move(data_ani, out_dir, conv_dir, tail_elements = 10,
             paths_mode = "simple", frames_nmax = 50,
             img_caption = img_caption, img_title = img_title,
             img_sub = img_sub, log_level = 1)

}
\seealso{
\code{\link{get_imconvert}}, \code{\link{animate_stats}}, \code{\link{animate_raster}}
}
\author{
Jakob Schwalb-Willmann
}
