% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_track_id.R
\name{mt_track_id}
\alias{mt_track_id}
\alias{mt_track_id<-}
\alias{mt_set_track_id}
\alias{mt_n_tracks}
\title{Retrieve the column with track ids or get the number of tracks}
\usage{
mt_track_id(x)

mt_track_id(x) <- value

mt_set_track_id(x, value)

mt_n_tracks(x)
}
\arguments{
\item{x}{a \code{move2} object}

\item{value}{either the new track id values or the name of the new track id column as a scalar character.
When the column is present then that column is used, otherwise the existing track id column is renamed}
}
\value{
\code{mt_track_id} returns a vector of the length of the number of locations that indicated the points belonging to one track. \cr
\code{mt_n_tracks} returns the number of tracks.
}
\description{
\itemize{
\item \code{mt_track_id()} retrieve track ids
\item \code{mt_track_id(x) <- value} and \code{mt_set_track_id(x, value)}  replace track ids with new values
\item \code{mt_n_tracks()} returns the number of tracks
}
}
\details{
When changing the track ids with new values that results in the combination
of several tracks, the track attributes of these tracks are also combined.
This is done by creating a lists within each column. See examples.
}
\examples{
x <- mt_read(mt_example())
mt_n_tracks(x)
mt_track_id(x) |> table()
x <- mt_sim_brownian_motion()
x$new_id <- gl(4, 5)
x |> mt_set_track_id("new_id")
mt_track_id(x) <- gl(4, 5)
## example of track data attributes being combined
m <- mt_sim_brownian_motion(1:3, tracks = letters[5:8]) |>
  mutate_track_data(sex = c("f", "f", "m", "m"), age = c(4, 4, 5, 6), old_track = track)
new_m <- m |> mt_set_track_id(c(rep("a", 6), rep("b", 6)))
mt_track_data(new_m)
}
