setGeneric("moveStack", function(x) standardGeneric("moveStack"))
setMethod(f = "moveStack", 
	  signature = c(x="list"),
	  definition = function(x){
		  if (any((as.character(lapply(x, class)))!="Move")) 
			  stop("One or more objects in the list are not from class Move")
		  if(!all(unlist(lapply(x, validObject))))
			  stop("One or more objects in the list are not valid Move objects")
		  if (length(unique(as.character(lapply(x, function(y) attr(slot(y, "timestamps"), "tzone")) )))!=1)
			  stop("One or more objects in the list have no UTC timestamps")

		  if(!equalProj(x)) stop("All objects need to be equally projected.") 

		  if(any(duplicated(unlist(lapply(lapply(x, slot, "idData"), rownames))))){
			  nnames <- make.names(unlist(lapply(lapply(x, slot, "idData"), rownames)),unique=T)
			  lapply(1:length(nnames), function(z, nnames, x) {rownames(x[[z]]@idData)<-nnames[z]
				 return(x[[z]])}, x=x, nnames=nnames)
			  warning("Detected duplicated names. Renamed the duplicated individuals accordingly.")
		  }
		  length <- lapply(lapply(x, coordinates), nrow)
		  coords <- do.call(rbind, lapply(x, coordinates))
		  colnames(coords) <- c("location.long", "location.lat")
		  allData <- lapply(x, function(y) slot(y, "data"))
		  allColumns <- unique(unlist(sapply(allData, names)))

		  ###DATA
		  DATA <- do.call("rbind", lapply(allData, FUN = function(entry) {
						  missingColumns <- allColumns[which(!allColumns %in% names(entry))]
						  entry[, missingColumns] <- NA
						  entry})) #thanks to: Karl Ove Hufthammer

		  ###idData
		  allidData <- lapply(x, function(y) slot(y, "idData"))
		  allidColumns <- unique(unlist(sapply(allidData, names)))
		  IDDATA <- do.call("rbind", lapply(allidData, FUN = function(entry) {
						    missingColumns <- allidColumns[which(!allidColumns %in% names(entry))]
						    entry[, missingColumns] <- NA
						    entry}))
		  id <- raster:::.goodNames(rownames(IDDATA))
		  rownames(IDDATA)<-id

		  spdftmp <- SpatialPointsDataFrame(
						    coords = coords,
						    data = DATA, 
						    proj4string = CRS(proj4string(x[[1]])), #projection tested above
						    match.ID = TRUE)

		  # unused records
		  unUsedList<-lapply(x, as, ".unUsedRecords")
		  tz<-unique(unlist(lapply(ts<-lapply(unUsedList,slot,"timestampsUnUsedRecords"), attr, "tzone")))
		  if(!(length(tz)==1|is.null(tz )))
			  stop("Concatinating multiple time zone for unusedrecords")
		  dataUnUsed<-lapply(unUsedList, slot, 'dataUnUsedRecords')
		  cols<-unique(unlist(lapply(dataUnUsed, colnames)))
		  dataUnUsed<-lapply(dataUnUsed, function(x,i){
				     i<-i[!(i%in%colnames(x))]
				     if(nrow(x)==0){
					     x<-as.data.frame(matrix(nrow=0, ncol=length(i)))
					     colnames(x)<-i
				     } else { x[,i]<-NA }
				     return(x)
						    }, i=cols)# fill unused columns with NA
		  unUsed<-new(".unUsedRecordsStack",
			      timestampsUnUsedRecords=do.call('c',ts) ,
			      dataUnUsedRecords=do.call('rbind',dataUnUsed ),
			      sensorUnUsedRecords=as.factor(unlist(lapply(unUsedList, slot, 'sensorUnUsedRecords') )),
			      trackIdUnUsedRecords=as.factor(unlist(mapply(rep, id, unlist(lapply(ts, length)))))
			      )
		  res <- new("MoveStack", 
			     idData = IDDATA,
			     spdftmp, 
			     timestamps = do.call("c", lapply(x, timestamps)),
			     sensor =factor(do.call('c',lapply(lapply(x, slot, 'sensor'),as.character))),
			     trackId = as.factor(rep(id, length)),
			     unUsed)
		  return(res)
	  })

