% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{mt_check_resolution}
\alias{mt_check_resolution}
\title{Check logging resolution by looking at timestamp differences.}
\usage{
mt_check_resolution(data, use = "trajectories", timestamps = "timestamps",
  desired = NULL)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{timestamps}{a character string specifying the trajectory dimension
containing the timestamps.}

\item{desired}{an optional integer. If specified, additional statistics are
computed concerning the (relative) frequencies with which exactly the
desired timestamp difference (with tolerance 1e-12) occurred.}
}
\value{
A list with various descriptive statistics. For convenience, the
  relative frequencies are rounded to 4 decimal places.
}
\description{
\code{mt_check_resolution} computes the timestamp differences as a measure of
the logging resolution. It provides various descriptive statistics to check
the logging resolution.
}
\details{
If mouse-tracking experiments are conducted using the mousetrap plug-ins for 
OpenSesame, the logging resolution can be specified explicitly in the 
experiment under "Logging resolution", which corresponds to the delay (in 
milliseconds) between recordings of the mouse position. By default, mouse 
positions are recorded every 10 ms (corresponding to a 100 Hz sampling rate).
As the actual resolution achieved depends on the performance of the hardware,
it makes sense to check the logging resolution using 
\code{mt_check_resolution}. Note that delays smaller than the specified delay
typically result from mouse clicks in the experiment.
}
\examples{
mt_check_resolution(mt_example)

}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
