% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{mt_plot_per_trajectory}
\alias{mt_plot_per_trajectory}
\title{Create pdf with separate plots per trajectory.}
\usage{
mt_plot_per_trajectory(file, data, use = "trajectories", x = "xpos",
  y = "ypos", xlim = NULL, ylim = NULL, axes_exact = FALSE,
  points = FALSE, rect = NULL, color = "black", fill = NA,
  verbose = FALSE, show_progress = NULL, ...)
}
\arguments{
\item{file}{a character string specifying the name of the pdf file. Passed on
to \link{pdf}.}

\item{data}{a mousetrap data object created using one of the mt_import 
functions (e.g., \link{mt_import_mousetrap}).}

\item{use}{a character string specifying which trajectories should be 
plotted. The corresponding trajectories are selected from data using 
\code{data[[use]]}. Usually, this value corresponds to either 
"trajectories", "tn_trajectories" or "av_trajectories", depending on 
whether the raw, time-normalized or averaged trajectories should be 
plotted.}

\item{x}{a character string specifying which dimension in the trajectory 
array should be displayed on the x-axis (defaults to xpos).}

\item{y}{a character string specifying which dimension in the trajectory 
array should be displayed on the y-axis (defaults to ypos).}

\item{xlim}{optional argument specifying the limits for the x axis (passed on
to \link[ggplot2]{coord_cartesian}). If not specified (the default), 
sensible axis limits will be computed.}

\item{ylim}{optional argument specifying the limits for the y axis (passed on
to \link[ggplot2]{coord_cartesian}). If not specified (the default), 
sensible axis limits will be computed.}

\item{axes_exact}{logical. If \code{TRUE}, axes will be set without offset
exactly at the limits of the x and y axes (which can be specified using
\code{xlim} and \code{ylim}]).}

\item{points}{logical. If \code{TRUE}, points will be added to the plot using
\link[ggplot2]{geom_point}.}

\item{rect}{optional argument passed on to \link{mt_plot_add_rect}. If
specified, rectangles (usually representing the response buttons) will be
plotted for each trajectory plot.}

\item{color}{optional argument passed on to \link{mt_plot_add_rect}. Only
relevant if \code{rect} is specified.}

\item{fill}{optional argument passed on to \link{mt_plot_add_rect}. Only
relevant if \code{rect} is specified.}

\item{verbose}{logical indicating whether function should report its 
progress.}

\item{show_progress}{Deprecated. Please use \code{verbose} instead.}

\item{...}{additional arguments passed on to \link{pdf}.}
}
\description{
\code{mt_plot_per_trajectory} creates a PDF file with separate plots per 
trajectory. This PDF can be used for inspecting individual trajectories. Note
that plotting all trajectories can be time-consuming, especially for raw 
trajectories. If the appropriate \code{x} and \code{y} arguments are
inserted, this function can also be used for plotting velocity and
acceleration profiles.
}
\details{
\code{mt_plot_per_trajectory} creates a PDF using \link{pdf}. Next, it plots 
all trajectories individually using \link{mt_plot}. Every plot is labeled 
using the \link{rownames} of the trajectories.
}
\examples{
\dontrun{
mt_plot_per_trajectory(mt_example,
  file="trajectories.pdf",
  use="trajectories")
}

}
\seealso{
\link{mt_plot} for plotting trajectory data.
}

