% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{mt_aggregate_per_subject}
\alias{mt_aggregate_per_subject}
\title{Aggregate mouse-tracking data per condition separately for each subject.}
\usage{
mt_aggregate_per_subject(data, use = "measures", use_variables = NULL,
  use2 = "data", use2_variables = NULL, subject_id,
  trajectories_long = TRUE, ...)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import 
functions (see \link{mt_example} for details).}

\item{use}{a character string specifying which data should be reshaped. The
corresponding data are selected from data using \code{data[[use]]}. 
Usually, this value corresponds to either "tn_trajectories" or "measures", 
depending on whether the time-normalized trajectories or derived measures 
should be aggregated.}

\item{use_variables}{a character vector specifying which mouse-tracking
variables should be aggregated. Corresponds to the column names in case a
data.frame with mouse-tracking measures is provided. Corresponds to the
labels of the array dimensions in case a trajectory array is provided. If
unspecified, all variables will be aggregated.}

\item{use2}{a character string specifying where the data containing the
condition information can be found. Defaults to "data" as
\code{data[["data"]]} usually contains all non mouse-tracking trial data. 
Alternatively, a data.frame can be provided directly.}

\item{use2_variables}{a character string (or vector) specifying the variables
(in \code{data[[use2]]}) across which the trajectories / measures will be
aggregated. For each combination of levels of the grouping variable(s), 
aggregation will be performed separately using \link[reshape2]{dcast}.}

\item{subject_id}{a character string specifying which column contains the
subject identifier.}

\item{trajectories_long}{logical indicating if the reshaped trajectories 
should be returned in long or wide format. If \code{TRUE}, every recorded 
position in a trajectory is placed in another row (whereby the order of the
positions is logged in the variable \code{mt_seq}). If \code{FALSE}, every 
trajectory is saved in wide format and the respective positions are indexed
by adding an integer to the corresponding label (e.g., \code{xpos_1},
\code{xpos_2}, ...). Only relevant if \code{data[[use]]} contains
trajectories.}

\item{...}{additional arguments passed on to \link{mt_reshape} (such as
\code{subset}).}
}
\value{
A \link{data.frame} containing the aggregated data.
}
\description{
\code{mt_aggregate_per_subject} can be used for aggregating mouse-tracking
measures (or trajectories) per condition separately for each subject. One or
several condition variables can be specified using \code{use2_variables}. 
Aggregation will be performed separately for each level of the condition
variables. \code{mt_aggregate_per_subject} is a wrapper function for
\link{mt_reshape}.
}
\examples{
# Time-normalize trajectories
mt_example <- mt_time_normalize(mt_example)
  
# Aggregate time-normalized trajectories per condition
# separately per subject
average_trajectories <- mt_aggregate_per_subject(
  mt_example,
  use="tn_trajectories",
  use2_variables="Condition",
  subject_id="subject_nr"
)


# Calculate mouse-tracking measures
mt_example <- mt_calculate_measures(mt_example)

# Aggregate measures per condition
# separately per subject
average_measures <- mt_aggregate_per_subject(
  mt_example,
  use="measures",
  use_variables=c("MAD", "AD"),
  use2_variables="Condition",
  subject_id="subject_nr"
)

}
\seealso{
\link{mt_aggregate} for aggregating mouse-tracking measures and trajectories
per condition.

\link{aggregate} for aggregating data in R.

\link[reshape2]{dcast} for reshaping and aggregating data using the
\code{reshape2} package.
}

