% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.R
\name{run_laplace_embedding}
\alias{run_laplace_embedding}
\title{Run Laplace embedding}
\usage{
run_laplace_embedding(adj_mat, num_eigs, type_lap = c("comb", "rw"))
}
\arguments{
\item{adj_mat}{Symmetric adjacency matrix to be embedded.}

\item{num_eigs}{Number of eigenvalues and eigenvectors for the embedding.}

\item{type_lap}{Type of Laplacian for the embedding.
One of \code{"comb"} (combinatorial) or \code{"rw"} (random-walk).}
}
\value{
A list with two entries:
\code{vals} contains the length-\code{num_eigs} vector
of the first few eigenvalues of the Laplacian,
and \code{vects} contains an \code{nrow(adj_mat)} by \code{num_eigs} matrix
of the associated eigenvectors.
}
\description{
Run Laplace embedding on a symmetric (weighted) adjacency matrix
with a specified number of eigenvalues and eigenvectors.
}
\examples{
adj_mat <- matrix(c(1:9), nrow = 3)
run_laplace_embedding(adj_mat, 2, "rw")
}
