% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample_bsbm}
\alias{sample_bsbm}
\title{Sample a bipartite stochastic block model (BSBM)}
\usage{
sample_bsbm(
  source_block_sizes,
  dest_block_sizes,
  bipartite_connection_matrix,
  bipartite_weight_matrix = NULL,
  sample_weight_type = c("unweighted", "constant", "poisson")
)
}
\arguments{
\item{source_block_sizes}{A vector containing the size of each block
of source vertices.}

\item{dest_block_sizes}{A vector containing the size of each block
of destination vertices.}

\item{bipartite_connection_matrix}{A matrix containing the
source block to destination block
connection probabilities.}

\item{bipartite_weight_matrix}{A matrix containing the
source block to destination block weight parameters.
Unused for \code{sample_weight_type = "constant"}.
Defaults to \code{NULL}.}

\item{sample_weight_type}{The type of weighting scheme.
One of \code{"unweighted"}, \code{"constant"} or \code{"poisson"}.}
}
\value{
A randomly sampled (weighted) adjacency matrix of a BSBM.
}
\description{
Sample the (weighted) adjacency matrix of a (weighted) bipartite stochastic
block model (BSBM) with specified parameters.
}
\examples{
source_block_sizes <- c(10, 10)
dest_block_sizes <- c(10, 10, 10)
bipartite_connection_matrix <- matrix(c(0.8, 0.5, 0.1, 0.1, 0.5, 0.8),
      nrow = 2, byrow = TRUE)
bipartite_weight_matrix = matrix(c(20, 10, 2, 2, 10, 20),
      nrow = 2, byrow = TRUE)
sample_bsbm(source_block_sizes, dest_block_sizes,
      bipartite_connection_matrix, bipartite_weight_matrix, "poisson")
}
