% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bottom_up.R
\name{multiscale.bottomUp}
\alias{multiscale.bottomUp}
\title{Multiscale MOSUM algorithm with bottom-up merging}
\usage{
multiscale.bottomUp(x, G = bandwidths.default(length(x)),
  threshold = c("critical.value", "custom")[1], alpha = 0.05,
  threshold.function = NULL, eta = 0.4, do.confint = F, level = 0.05,
  N_reps = 1000, ...)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{a vector of (symmetric) bandwidths, given as either integers or numbers between 
\code{0} and \code{0.5} describing the moving sum bandwidths relative to \code{length(x)}}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, it is chosen from the asymptotic distribution at the given significance level \code{alpha}.
Alternatively, it is possible to parse a user-defined function with \code{threshold.function}}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}; use iff \code{threshold='critical.value'}}

\item{threshold.function}{function object of form \code{function(G, length(x), alpha)}, to compute a
threshold of significance for different bandwidths G; use iff \code{threshold='custom'}}

\item{eta}{see \link[mosum]{mosum}}

\item{do.confint}{flag indicating whether to compute the confidence intervals for change-points}

\item{level}{use iff \code{do.confint=TRUE}; a numeric value (\code{0 <= level <= 1}) with which
\code{100(1-level)\%} confidence interval is generated}

\item{N_reps}{use iff \code{do.confint=TRUE}; number of bootstrap replicates to be generated}

\item{...}{further arguments to be passed to the \link[mosum]{mosum} calls}
}
\value{
S3 \code{multiscale.cpts} object, which contains the following fields:
   \item{x}{input data}
   \item{cpts}{estimated change-points}
   \item{cpts.info}{data frame containing information about estimated change-points}
   \item{pooled.cpts}{set of change-point candidates that have been considered by the algorithm}
   \item{G}{bandwidths}
   \item{threshold,alpha,threshold.function}{input parameters}
   \item{eta}{input parameters}
   \item{do.confint}{input parameter}
   \item{ci}{object of class \code{cpts.ci} containing confidence intervals for change-points iff \code{do.confint=TRUE}}
}
\description{
Multiscale MOSUM procedure with symmetric bandwidths combined with
bottom-up bandwidth-based merging.
}
\details{
See Algorithm 1 in the first referenced paper for a comprehensive
description of the procedure and further details.
}
\examples{
x <- testData(lengths=c(50, 50, 200, 300, 300), means=c(0, 1, 2, 3, 2.3), sds=rep(1, 5))
G <- (5:20)*5
mbu <- multiscale.bottomUp(x, G=G, alpha=0.1)
summary(mbu)
}
\references{
A. Meier, C. Kirch and H. Cho (2018+)
mosum: A Package for Moving Sums in Change Point Analysis. \emph{Unpublished manuscript}.

M. Messer et al. (2014)
A multiple filter test for the detection of rate changes in renewal processes with varying variance.
\emph{The Annals of Applied Statistics}, Volume 8, Number 4, pp. 2027-2067.
}
