% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_data.R
\name{testData}
\alias{testData}
\title{Test data with piecewise constant mean}
\usage{
testData(model = c("custom", "blocks", "fms", "mix", "stairs10",
  "teeth10")[1], lengths = NULL, means = NULL, sds = NULL,
  rand.gen = rnorm, seed = NULL, ...)
}
\arguments{
\item{model}{a string indicating from which model a realisation is to be generated;
possible values are 'blocks', 'fms', 'mix', 'stairs10', 'teeth10'
(for the referenced model signals) or 'custom' (for user specification 
in terms of \code{lengths}, \code{means} and \code{sds})}

\item{lengths}{use iff \code{model='custom'}; an integer vector for the lengths of the piecewise stationary segments}

\item{means}{use iff \code{model='custom'}; a numeric vector for the means of the piecewise stationary segments}

\item{sds}{use iff \code{model='custom'}; a numeric vector for the deviation scaling of the piecewise stationary segments.
The values are multiplied to the outcome of \code{rand.gen}, coinciding with the standard
deviation in case of standard normal innovations (\code{rand.gen=rnorm})}

\item{rand.gen}{optional; a function to generate the noise/innovations}

\item{seed}{optional; if a seed value is provided (\code{!is.null(seed)}), 
then \code{set.seed(seed)} is called beforehand)}

\item{...}{further arguments to be parsed to \code{rand.gen}}
}
\value{
numeric vector containing a realisation of the time series, given as signal+noise
}
\description{
Generate piecewise stationary time series with change-points in the mean.
}
\details{
See Appendix B in the reference for details about the model time series.
}
\references{
P. Fryzlewicz (2014)
Wild Binary Segmentation for Multiple Change-Point Detection.
\emph{The Annals of Statistics}, Volume 42, Number 6, pp. 2243-2281.
}
