% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolicD.R
\name{symbolicD}
\alias{symbolicD}
\title{Symbolic Derivatives}
\usage{
symbolicD(formula, ..., .order = NULL)
}
\arguments{
\item{formula}{a mathematical expression (see examples and \code{\link{plotFun}})}

\item{\dots}{additional parameters, typically default values for mathematical parameters}

\item{.order}{a number specifying the order of a derivative with respect to a single variable}
}
\value{
a function implementing the derivative
}
\description{
Constructs symbolic derivatives of some mathematical expressions
}
\details{
Uses the built-in symbolic differentiation function to construct 
a formula for the derivative and packages this up as a function.
The \code{.order} argument is just for convenience when programming
high-order derivatives, e.g. the 5th derivative w.r.t. one variable.
}
\examples{
symbolicD( a*x^2 ~ x)
symbolicD( a*x^2 ~ x&x)
symbolicD( a*sin(x)~x, .order=4)
symbolicD( a*x^2*y+b*y ~ x, a=10, b=100 )
}
\seealso{
\code{\link{D}}, \code{\link{numD}}, \code{\link{makeFun}}, \code{\link{antiD}}, \code{\link{plotFun}}
}
\author{
Daniel Kaplan (\email{kaplan@macalester.edu})
}
