% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masculinity_maternalmortality.R
\name{lt.sexrelation}
\alias{lt.sexrelation}
\title{Calculate masculinity index and maternal mortality
from a mortAAR life table list}
\usage{
lt.sexrelation(females, males)
}
\arguments{
\item{females}{an object of class mortaar_life_table for females}

\item{males}{an object of class mortaar_life_table for males}
}
\value{
Output of masculinity index and maternal mortality.
\itemize{
  \item \bold{Masculinity index}.

                   \eqn{MI = D>=15male * 100 / D>=15female}

  \item \bold{Maternal mortality}.

                   \eqn{333.33 * D20-24female / D20-24male - 76.07}
}
}
\description{
The proportional relation between adult males and females (=
Masculinity index) is interesting for a number of reasons: (1)
it can point to basic problems in the datasets in that, say,
one sex is grossly over- or underrepresented (\emph{Herrmann et al.
1990}, 310). (2) it may hint towards cultural reasons like sex-
specific mobility.\cr
Maternal mortality is a basic indicator for the health system of a
given population. Maternal mortality is defined as dying during
pregnancy or within the first 42 days after birth due to
complications. Recently, \emph{McFadden and Oxenham 2019} have
provided a formula to calculate it from archaeological data.
}
\details{
The Masculinity index (MI) is defined for juvenile and older
individuals. Note that with a higher mortality rate of adult females,
an MI < 100 does not necessarily speak for an unbalanced MI in life.\cr
Maternal mortality is calculated according to the formula
provided by \emph{McFadden & Oxenham 2019}. McFadden and Oxenham show
that with modern data a very high correlation is achieved by only
comparing the absolute numbers of the age group 20 to 24. This has the
additional advantage that for this age group anthropological aging
methods are reasonable exact.
}
\examples{
# Calculate Masculinity index and maternal mortality from Nitra
# dataset.
nitra_prep <- prep.life.table(nitra, group="sex", agebeg = "age_start", ageend = "age_end")
nitra_life <- life.table(nitra_prep)
lt.sexrelation(nitra_life$f, nitra_life$m)

}
\references{
\insertRef{herrmann_prahistorische_1990}{mortAAR}

\insertRef{mcfadden_oxenham_2019}{mortAAR}
}
