% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFit.survDataCstExp.R
\name{survFit.survDataCstExp}
\alias{survFit.survDataCstExp}
\title{Fits a TKTD model for survival analysis using Bayesian inference for \code{survDataCstExp} object}
\usage{
\method{survFit}{survDataCstExp}(data, model_type = NULL, quiet = FALSE,
  n.chains = 3, n.adapt = 3000, n.iter = NULL, n.warmup = NULL,
  thin.interval = NULL, limit.sampling = TRUE, dic.compute = FALSE,
  dic.type = "pD", ...)
}
\arguments{
\item{data}{An object of class \code{survDataCstExp}.}

\item{model_type}{can be \code{"SD"} or \code{"IT"} to choose
between "Stochastic Death" or "Individual Tolerance" models.}

\item{quiet}{If \code{FALSE}, prints logs and progress bar from
JAGS.}

\item{n.chains}{A positive integer specifying the number of MCMC chains. The minimum required number 
of chains is 2.}

\item{n.adapt}{A positive integer specifying the number of iterations for adaptation. If \code{n.adapt} = 0
then no adaptation takes place.}

\item{n.iter}{A positive integer specifying the number of iterations to monitor for each chain.}

\item{n.warmup}{A positive integer specifying the number of warmup (aka burnin) iterations per chain.}

\item{thin.interval}{A positive integer specifying the period to monitor.}

\item{limit.sampling}{If \code{FALSE} (default is \code{TRUE}), there is no limit to the number of iterations
in MCMC imposed by the \code{raftery.diag} test.}

\item{dic.compute}{if \code{TRUE} (default is \code{FALSE}), it generates penalized deviance samples to compute
the Deviance Information Criterion (DIC) with the \code{rjags} package}

\item{dic.type}{type of penalty to use. A string identifying the type of penalty: \code{pD} or \code{popt}
(see function \code{\link[rjags]{dic.samples}})}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns an object of class \code{survFitCstExp}, which is
a list with the following information:
\item{estim.par}{a table of the estimated parameters as medians and 95\%
credible intervals}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior
distribution}
\item{model}{a JAGS model object}
\item{dic}{return the Deviance Information Criterion (DIC) if \code{dic.compute} is \code{TRUE}}
\item{warnings}{a table with warning messages}
\item{parameters}{a list of parameter names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation}
\item{mcmcInfo}{a table with the number of iterations, chains, adaptation, warmup and the thinning interval.} 
\item{jags.data}{a list of the data passed to the JAGS model}
\item{model_type}{the type of TK-TD model used: \code{SD} or \code{IT}}
}
\description{
This function estimates the parameters of a TKTD model ('SD' or 'IT')
for survival analysis using Bayesian inference. In this model,
the survival rate of individuals is modeled as a function of the chemical compound
concentration with a mechanistic description of the effects on survival over
time.
}
\details{
The function \code{survFit} return the parameter estimates of Toxicokinetic-toxicodynamic (TK-TD) models
\code{SD} for 'Stochastic Death' or \code{IT} fo 'Individual Tolerance'.
TK-TD models, and particularly the General Unified Threshold model of
Survival (GUTS), provide a consistent process-based
framework to analyse both time and concentration dependent datasets.
In GUTS-SD, all organisms are assumed to have the same internal concentration 
threshold (denoted \eqn{z}), and, once exceeded, the instantaneous probability
to die increases linearly with the internal concentration.
In GUTS-IT, the threshold concentration is distributed among all the organisms, and once 
exceeded in one individual, this individual dies immediately.
}
\examples{

# (1) Load the survival data
data(propiconazole)

# (2) Create an object of class "survData"
dataset  <- survData(propiconazole)

\dontrun{
# (3) Run the survFit function with TK-TD model 'SD' or 'IT' 
out <- survFit(dataset , model_type = "SD")

# (4) Summarize look the estimated parameters
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = TRUE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE , adddata = TRUE)
}

}
\references{
Jager, T., Albert, C., Preuss, T. G. and Ashauer, R. (2011) 
General unified threshold model of survival-a toxicokinetic-toxicodynamic
 framework for ecotoxicology, \emph{Environmental Science and Technology}, 45, 2529-2540.
303-314.
}
\keyword{estimation}
