% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapArea.R
\name{morphomapArea}
\alias{morphomapArea}
\title{morphomapArea}
\usage{
morphomapArea(p, delta = 0.1, method = "shoelace")
}
\arguments{
\item{p}{matrix: kx2 matrix}

\item{delta}{numeric: picture elements of adjustable side length}

\item{method}{character: the user can choice to calculate the area applying the "shoelace" formula or discretizing the cross sections in dA areas (method = "delta")}
}
\value{
ar numeric: area
}
\description{
Shoelace formula to calculate the area of a closed outline
}
\examples{
extsec<-morphomapCircle(10,100)
#shoelace method
area<-morphomapArea(extsec, method="shoelace")
#delta method
area<-morphomapArea(extsec, method="delta",delta=0.01)
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
