% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapThickness.R
\name{morphomapThickness}
\alias{morphomapThickness}
\title{morphomapThickness}
\usage{
morphomapThickness(morphomap.shape)
}
\arguments{
\item{morphomap.shape}{list: morphomap.shape object}
}
\value{
sect_thickness cortical thickness at each pair of landmarks on the external and internal outlines

ALPM_thickness cortical thickness at ALPM quadrants
}
\description{
Tool for the extraction of equiangular landmarks on the entire diaphysis
}
\examples{
\donttest{
#morphomap on a human femur bone
data(HomFem38023)
meshes<-morphomapSegm(HomFem38023)
perMesh<-meshes$external
endMesh<-meshes$internal
mech_length<-380.23
rawSections<-morphomapCore(out.sur=perMesh,
                           inn.sur=endMesh,num.sect=61,mech.len = mech_length, 
                           start = 0.2,end=0.8)
shapeSections<-morphomapShape(rawSections,21,sects_vector=NULL,cent.out="CCA",delta=0.1)
femthick<-morphomapThickness(shapeSections)
plot(femthick$ALPM_thickness[1,,],type="l",
     main="LAMP thickness",xlab="section",ylab="thickness")
points(femthick$ALPM_thickness[2,,],type="l",col=2)
points(femthick$ALPM_thickness[3,,],type="l",col=3)
points(femthick$ALPM_thickness[4,,],type="l",col=4)
}
}
\author{
Antonio Profico, Luca Bondioli, Pasquale Raia, Paul O'Higgins, Damiano Marchi
}
