% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{transform_maximise}
\alias{transform_maximise}
\title{Transform matrix according to maximise parameter}
\usage{
transform_maximise(x, maximise)
}
\arguments{
\item{x}{\code{matrix()}|\code{data.frame()}\cr Matrix or data frame of numerical
values, where each row gives the coordinates of a point.}

\item{maximise}{\code{logical()}\cr Whether the objectives must be maximised
instead of minimised. Either a single logical value that applies to all
objectives or a vector of logical values, with one value per objective.}
}
\value{
\code{x} transformed such that every column where \code{maximise} is \code{TRUE} is multiplied by \code{-1}.
}
\description{
Transform matrix according to maximise parameter
}
\examples{
x <- data.frame(f1=1:10, f2=101:110)
rownames(x) <- letters[1:10]
transform_maximise(x, maximise=c(FALSE,TRUE))
transform_maximise(x, maximise=TRUE)
x <- as.matrix(x)
transform_maximise(x, maximise=c(FALSE,TRUE))
transform_maximise(x, maximise=TRUE)

}
