% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/heatmapAnnot.R
\name{heatmapAnnot}
\alias{heatmapAnnot}
\title{Annotated heat map}
\usage{
heatmapAnnot(x, labcol, xlab = "", ylab = "", genus = "", rowlab = TRUE,
  pt = 0.25)
}
\arguments{
\item{x}{a matrix with rows representing species samples and columns representing morphometrical variables of
interest}

\item{labcol}{a character vector giving the color annotation for the species}

\item{xlab}{title for x-axis}

\item{ylab}{title for y-axis}

\item{genus}{single character abbreviation for genus}

\item{rowlab}{if FALSE, suppresses row labels on the heat map}

\item{pt}{if the rows have been ranked, two lines are drawn - one at the \code{pt}x100th percentile (bottom),
the other at the (1-\code{pt})x100th percentile (top); set to 0 to disable}
}
\description{
This function produces a heat map with hierarchical clustering of samples using multivariate size or shape data.
}
\details{
This function customizes the \code{heatmap.2} function in the \code{gplots} package (Version 2.17.0).
Pairwise distances between samples are computed using unsquared Euclidean distance, therefore
clustering is based on the generalized Ward criterion (Batagelj, 1988). Row standardization is switched on,
and a color legend for species is given in the left panel.
}
\examples{
library(gplots)

data(ligophorus_shape)
data(spcolmap)

dendrogram <- hclust(dist(ligophorus_shape))

#check dendrogram and note cut-off for the two main clades
plot(dendrogram)

clade_id <- cutree(dendrogram, h=0.55)

f_s <- numeric(ncol(ligophorus_shape))

for(i in 1:ncol(ligophorus_shape)){
dat <- stack(ligophorus_shape[,i])
#replace species label with clade label
dat[,2] <- clade_id
f_s[i] <- t.test(values~ind, data=dat)$statistic
}

rank_s <- order(f_s, decreasing=TRUE)

heatmapAnnot(ligophorus_shape[,rank_s],labcol=spcolmap$color,
xlab="Specimens", genus="L. ")
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Batagelj V. (1988). Generalized Ward and related clustering problems. In: Classification and Related Methods of Data Analysis. H.H.Bock (ed.). Amsterdam: North-Holland, pp. 67-74.

Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.

Warnes GR, Bolker B, Bonebakker L, Gentleman R, Huber W, Liaw A, Lumley T,Maechler M, Magnusson M, Moeller S,
Schwartz M, Venables B. (2015). gplots:Various R programming tools for plotting data. R package version 2.17.0.
Available at: http://CRAN.R-project.org/package=gplots.
}

