% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.MonoClust.R
\name{plot.MonoClust}
\alias{plot.MonoClust}
\title{Plot MonoClust Splitting Rule Tree}
\usage{
\method{plot}{MonoClust}(
  x,
  uniform = FALSE,
  branch = 1,
  margin = c(0.12, 0.02, 0, 0.05),
  minbranch = 0.3,
  text = TRUE,
  which = 4,
  stats = TRUE,
  abbrev = c("no", "short", "abbreviate"),
  digits = getOption("digits") - 2,
  cols = NULL,
  col.type = c("l", "p", "b"),
  rel.loc.x = TRUE,
  show.pval = TRUE,
  ...
)
}
\arguments{
\item{x}{MonoClust result object.}

\item{uniform}{If TRUE, uniform vertical spacing of the nodes is used; this
may be less cluttered when fitting a large plot onto a page. The default is
to use a non-uniform spacing proportional to the inertia in the fit.}

\item{branch}{Controls the shape of the branches from parent to child node.
Any number from 0 to 1 is allowed. A value of 1 gives square shouldered
branches, a value of 0 give V shaped branches, with other values being
intermediate.}

\item{margin}{An extra fraction of white space to leave around the borders of
the tree. (Long labels sometimes get cut off by the default computation).}

\item{minbranch}{Set the minimum length for a branch to \code{minbranch} times the
average branch length. This parameter is ignored if \code{uniform = TRUE}.
Sometimes a split will give very little improvement, or even no improvement
at all. A tree with branch lengths strictly proportional to improvement
leaves no room to squeeze in node labels.}

\item{text}{Whether to print the labels on the tree.}

\item{which}{Labeling modes, which are:
\itemize{
\item 1: only splitting variable names are shown, no splitting rules.
\item 2: only splitting rules to the left branches are shown.
\item 3: only splitting rules to the right branches are shown.
\item 4 (default): splitting rules are shown on both sides of branches.
}}

\item{stats}{Whether to show statistics (cluster sizes and medoid points) on
the tree.}

\item{abbrev}{Whether to print the abbreviated versions of variable names.
Can be either "no" (default), "short", or "abbreviate". Short forms of them
can also be used.

If "no", the labels recorded in \code{x$labels} are used.

If "short", variable names will be turned into "V1", "V2", ...

If "abbreviate", \code{\link[=abbreviate]{abbreviate()}} function will be used. Use the optional
arguments for this function.}

\item{digits}{Number of significant digits to print.}

\item{cols}{Whether to shown color bars at leaves or not. It helps matching
this tree plot with other plots whose cluster membership were colored. It
only works when \code{text} is \code{TRUE}. Either \code{NULL}, a vector of one color, or
a vector of colors matching the number of leaves.}

\item{col.type}{When \code{cols} is set, choose whether the color indicators are
shown in a form of solid lines below the leaves (\code{"l"}), or big points
(\code{"p"}), or both (\code{"b"}).}

\item{rel.loc.x}{Whether to use the relative distance between clusters as x
coordinate of the leaves. Default is TRUE.}

\item{show.pval}{If MonClust object has been run through \code{\link[=perm.test]{perm.test()}},
whether to show p-value on the tree.}

\item{...}{Arguments to be passed to \code{\link[graphics:plot.default]{graphics::plot.default()}} and
\code{\link[graphics:lines]{graphics::lines()}}.}
}
\value{
A plot of splitting rule.
}
\description{
Print the MonoClust tree in the form of dendrogram.
}
\examples{
library(cluster)
data(ruspini)

# MonoClust tree
ruspini4sol <- MonoClust(ruspini, nclusters = 4)
plot(ruspini4sol)#'
\donttest{
# MonoClust tree after permutation test is run
ruspini6sol <- MonoClust(ruspini, nclusters = 6)
ruspini6_test <- perm.test(ruspini6sol,
                           data = ruspini,
                           method = "sw",
                           rep = 1000)
plot(ruspini6_test, branch = 1, uniform = TRUE)
}
}
