% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.test.R
\name{cluster_stats}
\alias{cluster_stats}
\title{Cluster Statistics Calculation}
\usage{
cluster_stats(d, clustering)
}
\arguments{
\item{d}{Distance object (as generated by \code{\link[=dist]{dist()}}) or a distance matrix
between cases.}

\item{clustering}{Integer vector of length of the number of cases, which
indicates a clustering. The clusters have to be numbered from 1 to the
number of clusters.}
}
\value{
\describe{
\item{f_stat}{Calinski-Harabasz's pseudo-F.}
\item{asw}{Average silhouette width.}
}
}
\description{
Calinski-Harabaz's pseudo-F (Calinski and Harabasz, 1974) and Average
silhoutte width (Rousseeuw, 1987) calculation.
}
\references{
\itemize{
\item Caliński, T. and Harabasz, J (1974). "A dendrite method for cluster
analysis". en. In: \emph{Communications in Statistics} 3.1, pp. 1–27.
\item Rousseeuw, P. J. (1987). "Silhouettes: A graphical aid to the
interpretation and validation of cluster analysis". In: \emph{Journal of
Computational and Applied Mathematics} 20, pp. 53–65. ISSN: 03770427. DOI:
10.1016/0377-0427(87) 90125-7.
}
}
\seealso{
\code{\link[cluster:silhouette]{cluster::silhouette()}}
}
\keyword{internal}
