% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n2w.R
\name{n2w}
\alias{n2w}
\title{Scaling function: natural to working parameters.}
\usage{
n2w(
  par,
  bounds,
  beta,
  delta = NULL,
  nbStates,
  estAngleMean,
  DM,
  cons,
  workcons,
  Bndind,
  dist
)
}
\arguments{
\item{par}{Named list of vectors containing the initial parameter values for each data stream.}

\item{bounds}{Named list of 2-column matrices specifying bounds on the natural (i.e, real) scale of the probability 
distribution parameters for each data stream.}

\item{beta}{List of regression coefficients for the transition probabilities.}

\item{delta}{Initial distribution. Default: \code{NULL} ; if the initial distribution is not estimated.}

\item{nbStates}{The number of states of the HMM.}

\item{estAngleMean}{Named list indicating whether or not to estimate the angle mean for data streams with angular 
distributions ('vm' and 'wrpcauchy').}

\item{DM}{An optional named list indicating the design matrices to be used for the probability distribution parameters of each data 
stream. Each element of \code{DM} can either be a named list of linear regression formulas or a matrix.}

\item{cons}{Named list of vectors specifying a power to raise parameters corresponding to each column of the design matrix 
for each data stream.}

\item{workcons}{Named list of vectors specifying constants to add to the regression coefficients on the working scale for 
each data stream.}

\item{Bndind}{Named list indicating whether \code{DM} is NULL with default parameter bounds for each data stream.}

\item{dist}{A named list indicating the probability distributions of the data streams.}
}
\value{
A vector of unconstrained parameters.
}
\description{
Scales each data stream probability distribution parameter from its natural interval to the set of real numbers, to allow for
unconstrained optimization. Used during the optimization of the log-likelihood. Parameters of
any data streams for which a design matrix is specified are ignored.
}
\examples{
\dontrun{
m<-example$m
nbStates <- 2
nbCovs <- 2
parSize <- list(step=2,angle=2)
par <- list(step=c(t(m$mle$step)),angle=c(t(m$mle$angle)))
bounds <- m$conditions$bounds
beta <- matrix(rnorm(6),ncol=2,nrow=3)
delta <- c(0.6,0.4)

#working parameters
wpar <- momentuHMM:::n2w(par,bounds,list(beta=beta),log(delta[-1]/delta[1]),nbStates,
m$conditions$estAngleMean,NULL,m$conditions$cons,m$conditions$workcons,m$conditions$Bndind,
m$conditions$dist)

#natural parameter
p <-   momentuHMM:::w2n(wpar,bounds,parSize,nbStates,nbCovs,m$conditions$estAngleMean,
m$conditions$circularAngleMean,lapply(m$conditions$dist,function(x) x=="vmConsensus"),
m$conditions$stationary,m$conditions$cons,m$conditions$fullDM,
m$conditions$DMind,m$conditions$workcons,1,m$conditions$dist,m$conditions$Bndind,
matrix(1,nrow=length(unique(m$data$ID)),ncol=1),covsDelta=m$covsDelta,
workBounds=m$conditions$workBounds)
}

}
