% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viterbi.R
\name{viterbi}
\alias{viterbi}
\title{Viterbi algorithm}
\usage{
viterbi(m, hierarchical = FALSE)
}
\arguments{
\item{m}{An object \code{\link{momentuHMM}} or \code{\link{momentuHierHMM}}}

\item{hierarchical}{Logical indicating whether or not to return a list of Viterbi-decoded states for each level of a hierarchical HMM. Ignored unless \code{m} is a \code{\link{momentuHierHMM}} object.}
}
\value{
The sequence of most probable states. If \code{hierarchical} is \code{TRUE}, then a list of the most probable states for each level of the hierarchy is returned.
}
\description{
For a given model, reconstructs the most probable states sequence,
using the Viterbi algorithm.
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

# reconstruction of states sequence
states <- viterbi(m)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
