% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPar0.R
\name{getPar0}
\alias{getPar0}
\title{Get starting values for new model from existing \code{momentuHMM} model fit}
\usage{
getPar0(model, nbStates = length(model$stateNames),
  estAngleMean = model$conditions$estAngleMean,
  circularAngleMean = model$conditions$circularAngleMean,
  formula = model$conditions$formula,
  formulaDelta = model$conditions$formulaDelta, DM = model$conditions$DM,
  stateNames = model$stateNames)
}
\arguments{
\item{model}{A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object (as returned by \code{\link{fitHMM}}, \code{\link{MIfitHMM}}, or \code{\link{MIpool}})}

\item{nbStates}{Number of states in the new model. Default: \code{nbStates=length(model$stateNames)}}

\item{estAngleMean}{Named list indicating whether or not the angle mean for data streams with angular 
distributions ('vm' and 'wrpcauchy') are to be estimated in the new model. Default: \code{estAngleMean=model$conditions$estAngleMean}}

\item{circularAngleMean}{Named list indicating whether circular-linear (FALSE) or circular-circular (TRUE) 
regression on the mean of circular distributions ('vm' and 'wrpcauchy') for turning angles are to be used in the new model. Default: \code{circularAngleMean=model$conditions$circularAngleMean}}

\item{formula}{Regression formula for the transition probability covariates of the new model (see \code{\link{fitHMM}}).  Default: \code{formula=model$conditions$formula}.}

\item{formulaDelta}{Regression formula for the initial distribution covariates of the new model (see \code{\link{fitHMM}}).  Default: \code{formulaDelta=model$conditions$formulaDelta}.}

\item{DM}{Named list indicating the design matrices to be used for the probability distribution parameters of each data stream in the new model (see \code{\link{fitHMM}}). Only parameters with design matrix column names that match those in model$conditions$fullDM are extracted, so care must be taken in naming columns if any elements of \code{DM}
are specified as matrices instead of formulas. Default: \code{DM=model$conditions$DM}.}

\item{stateNames}{Character vector of length \code{nbStates} indicating the names and order of the states in the new model. Default: \code{stateNames=model$stateNames[1:nbStates]}.}
}
\value{
A named list containing starting values suitable for \code{Par0} and \code{beta0} arguments in \code{\link{fitHMM}} or \code{\link{MIfitHMM}}:
\item{Par}{A list of vectors of state-dependent probability distribution parameters for 
each data stream specified in \code{model$conditions$dist}}
\item{beta}{Matrix of regression coefficients for the transition probabilities}
\item{delta}{Initial distribution of the HMM. Only returned if \code{stateNames} has the same membership as the state names for \code{model}}.

All other \code{\link{fitHMM}} (or \code{\link{MIfitHMM}}) model specifications (e.g., \code{dist}, \code{userBounds}, \code{workBounds}, etc.) and \code{data} are assumed to be the same 
for \code{model} and the new model (as specified by  \code{estAngleMean}, \code{circularAngleMean}, \code{formula}, \code{formulaDelta}, \code{DM}, and \code{stateNames}).
}
\description{
For nested models, this function will extract starting parameter values (i.e., \code{Par0} in \code{\link{fitHMM}} or \code{\link{MIfitHMM}}) from an existing \code{\link{momentuHMM}} model fit based on the provided arguments for the new model. Any parameters that are not in common between \code{model} and the new model (as specified by the arguments) are set to \code{0}. This function is intended to help users incrementally build and fit more complicated models from simpler nested models (and vice versa).
}
\examples{
# model is a momentuHMM object, automatically loaded with the package
model <- example$m
data <- model$data
dist <- model$conditions$dist
nbStates <- length(model$stateNames)
estAngleMean <- model$conditions$estAngleMean

newformula <- ~cov1+cov2
Par0 <- getPar0(model,formula=newformula)

\dontrun{
newModel <- fitHMM(model$data,dist=dist,nbStates=nbStates,
                   Par0=Par0$Par,beta0=Par0$beta,
                   formula=newformula,
                   estAngleMean=estAngleMean)
}

newDM1 <- list(step=list(mean=~cov1,sd=~cov1))
Par0 <- getPar0(model,DM=newDM1)

\dontrun{
newModel1 <- fitHMM(model$data,dist=dist,nbStates=nbStates,
                   Par0=Par0$Par,beta0=Par0$beta,
                   formula=model$conditions$formula,
                   estAngleMean=estAngleMean,
                   DM=newDM1)
}

# same model but specify DM for step using matrices
newDM2 <- list(step=matrix(c(1,0,0,0,
                           "cov1",0,0,0,
                           0,1,0,0,
                           0,"cov1",0,0,
                           0,0,1,0,
                           0,0,"cov1",0,
                           0,0,0,1,
                           0,0,0,"cov1"),nrow=nbStates*2))
                           
# to be extracted, new design matrix column names must match 
# column names of model$conditions$fullDM
colnames(newDM2$step)<-paste0(rep(c("mean_","sd_"),each=2*nbStates),
                      rep(1:nbStates,each=2),
                      rep(c(":(Intercept)",":cov1"),2*nbStates))
Par0 <- getPar0(model,DM=newDM2)
                      
\dontrun{
newModel2 <- fitHMM(model$data,dist=dist,nbStates=nbStates,
                   Par0=Par0$Par,beta0=Par0$beta,
                   formula=model$conditions$formula,
                   estAngleMean=estAngleMean,
                   DM=newDM2)
}

}
\seealso{
\code{\link{getPar}}, \code{\link{getParDM}}, \code{\link{fitHMM}}, \code{\link{MIfitHMM}}
}
